/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.transactional;

import com.anwen.mongo.transactional.MongoPlusTransactionalManager;
import com.mongodb.client.MongoClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionManager;

@DependsOn(value={"sqlExecute"})
public class MongoTransactionManagerAutoConfiguration {
    private final MongoClient mongoClient;

    public MongoTransactionManagerAutoConfiguration(MongoClient mongo) {
        this.mongoClient = mongo;
    }

    @Bean(value={"mongoPlusTransactionalManager"})
    @ConditionalOnMissingBean(value={TransactionManager.class})
    @ConditionalOnProperty(name={"mongo-plus.spring.transaction"}, havingValue="true")
    public PlatformTransactionManager mongoPlusTransactionalManager() {
        return new MongoPlusTransactionalManager(this.mongoClient);
    }
}

