/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.transactional;

import com.anwen.mongo.context.MongoTransactionContext;
import com.anwen.mongo.context.MongoTransactionStatus;
import com.mongodb.ClientSessionOptions;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoClient;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class MongoTransactionalAspect {
    private static final Logger logger = LoggerFactory.getLogger(MongoTransactionalAspect.class);
    private final MongoClient mongoClient;

    public MongoTransactionalAspect(MongoClient mongoClient) {
        this.mongoClient = mongoClient;
    }

    @Around(value="@annotation(com.anwen.mongo.annotation.transactional.MongoTransactional)")
    public Object manageTransaction(ProceedingJoinPoint joinPoint) throws Throwable {
        this.startTransaction();
        try {
            Object proceed = joinPoint.proceed();
            this.commitTransaction();
            Object object = proceed;
            return object;
        }
        catch (Exception e) {
            this.rollbackTransaction();
            throw e;
        }
        finally {
            this.closeSession();
        }
    }

    private void startTransaction() {
        ClientSession session = MongoTransactionContext.getClientSessionContext();
        if (session == null) {
            session = this.mongoClient.startSession(ClientSessionOptions.builder().causallyConsistent(true).build());
            session.startTransaction();
            MongoTransactionStatus status = new MongoTransactionStatus(session);
            MongoTransactionContext.setTransactionStatus((MongoTransactionStatus)status);
        }
        MongoTransactionContext.getMongoTransactionStatus().incrementReference();
        if (logger.isDebugEnabled()) {
            logger.debug("Mongo transaction created, Thread:{}, session hashcode:{}", (Object)Thread.currentThread().getName(), (Object)session.hashCode());
        }
    }

    private void commitTransaction() {
        ClientSession clientSession;
        MongoTransactionStatus status = MongoTransactionContext.getMongoTransactionStatus();
        if (status == null) {
            logger.warn("no session to commit.");
            return;
        }
        status.decrementReference();
        if (status.readyCommit() && (clientSession = status.getClientSession()).hasActiveTransaction()) {
            clientSession.commitTransaction();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Mongo transaction committed, Thread:{}, session hashcode:{}", (Object)Thread.currentThread().getName(), (Object)status.getClientSession().hashCode());
        }
    }

    private void rollbackTransaction() {
        MongoTransactionStatus status = MongoTransactionContext.getMongoTransactionStatus();
        if (status == null) {
            logger.warn("no session to rollback.");
            return;
        }
        status.clearReference();
        ClientSession clientSession = status.getClientSession();
        if (clientSession.hasActiveTransaction()) {
            clientSession.abortTransaction();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Mongo transaction rolled back, Thread:{}, session hashcode:{}", (Object)Thread.currentThread().getName(), (Object)status.getClientSession().hashCode());
        }
    }

    private void closeSession() {
        MongoTransactionStatus status = MongoTransactionContext.getMongoTransactionStatus();
        if (status == null) {
            logger.warn("no session to rollback.");
            return;
        }
        if (status.readyClose()) {
            try {
                ClientSession clientSession = status.getClientSession();
                if (clientSession.hasActiveTransaction()) {
                    clientSession.close();
                }
            }
            finally {
                MongoTransactionContext.clear();
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Mongo transaction closed, Thread:{}, session hashcode:{}", (Object)Thread.currentThread().getName(), (Object)status.getClientSession().hashCode());
        }
    }
}

