/*
 * Decompiled with CFR 0.152.
 */
package com.karuslabs.utilitary;

import com.karuslabs.utilitary.snippet.Line;
import com.karuslabs.utilitary.snippet.Snippet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import javax.lang.model.element.Modifier;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Texts {
    private static final String DELIMITER = "\n|    ";
    public static final BiConsumer<String, StringBuilder> STRING = (string, builder) -> builder.append((String)string);
    public static final BiConsumer<Object, StringBuilder> SCREAMING_CASE = (object, builder) -> builder.append(object.toString().toLowerCase().replace('_', ' '));

    public static String diagnose(String summary, Line line, Line issue, String message) {
        return Texts.diagnose(summary, line, Map.of(issue, message));
    }

    public static String diagnose(String summary, Line line, Map<Line, String> issues) {
        return Texts.diagnose(summary, Map.of(0, line), issues);
    }

    public static String diagnose(String summary, Snippet snippet, Line issue, String message) {
        return Texts.diagnose(summary, snippet, Map.of(issue, message));
    }

    public static String diagnose(String summary, Snippet snippet, Map<Line, String> issues) {
        return Texts.diagnose(summary, snippet.lines, issues);
    }

    static String diagnose(String summary, Map<Integer, Line> lines, Map<Line, String> issues) {
        HashMap<Integer, TreeMap> columns = new HashMap<Integer, TreeMap>();
        for (Map.Entry<Line, String> issue : issues.entrySet()) {
            columns.computeIfAbsent(issue.getKey().column, k -> new TreeMap()).put(issue.getKey(), issue.getValue());
        }
        StringBuilder builder = new StringBuilder().append(summary).append(DELIMITER);
        for (Line line : lines.values()) {
            builder.append(DELIMITER).append(" ".repeat(line.position)).append(line).append(Texts.render((TreeMap)columns.get(line.column)));
        }
        return builder.append(DELIMITER).toString();
    }

    static String render(@Nullable TreeMap<Line, String> issues) {
        if (issues == null) {
            return "";
        }
        StringBuilder underline = new StringBuilder().append(DELIMITER);
        TreeMap<Integer, StringBuilder> lines = new TreeMap<Integer, StringBuilder>();
        int times = issues.size() - 1;
        for (Map.Entry<Line, String> entry : issues.entrySet()) {
            Line line = entry.getKey();
            underline.append(Texts.pad(underline, line)).append(line.length() == 1 ? Character.valueOf('^') : "~".repeat(line.length()));
            if (line.equals(issues.lastKey())) {
                underline.append(" ").append(entry.getValue());
                continue;
            }
            Texts.render(times--, lines, entry.getKey(), entry.getValue());
        }
        for (StringBuilder line : lines.values()) {
            underline.append((CharSequence)line);
        }
        return underline.toString();
    }

    static void render(int times, Map<Integer, StringBuilder> builders, Line issue, String message) {
        for (int i = 0; i < times * 2; ++i) {
            StringBuilder builder = builders.computeIfAbsent(i, k -> new StringBuilder().append(DELIMITER));
            builder.append(Texts.pad(builder, issue)).append("|");
        }
        StringBuilder builder = builders.computeIfAbsent(times * 2, k -> new StringBuilder().append(DELIMITER));
        builder.append(Texts.pad(builder, issue)).append(message);
    }

    static String pad(StringBuilder builder, Line issue) {
        return " ".repeat(issue.position - builder.length() + DELIMITER.length());
    }

    public static <T> String and(Collection<? extends T> elements, BiConsumer<? super T, StringBuilder> consumer) {
        return Texts.conjunction(elements, consumer, "and");
    }

    public static <T> String and(T[] elements, BiConsumer<? super T, StringBuilder> consumer) {
        return Texts.conjunction(elements, consumer, "and");
    }

    public static <T> String or(Collection<? extends T> elements, BiConsumer<? super T, StringBuilder> consumer) {
        return Texts.conjunction(elements, consumer, "or");
    }

    public static <T> String or(T[] elements, BiConsumer<? super T, StringBuilder> consumer) {
        return Texts.conjunction(elements, consumer, "or");
    }

    public static <T> String conjunction(Collection<? extends T> elements, BiConsumer<? super T, StringBuilder> consumer, String conjunction) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (T element : elements) {
            consumer.accept(element, builder);
            if (i < elements.size() - 2) {
                builder.append(", ");
            } else if (i < elements.size() - 1) {
                builder.append(' ').append(conjunction).append(' ');
            }
            ++i;
        }
        return builder.toString();
    }

    public static <T> String conjunction(T[] elements, BiConsumer<? super T, StringBuilder> consumer, String conjunction) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < elements.length; ++i) {
            consumer.accept(elements[i], builder);
            if (i < elements.length - 2) {
                builder.append(", ");
                continue;
            }
            if (i >= elements.length - 1) continue;
            builder.append(' ').append(conjunction).append(' ');
        }
        return builder.toString();
    }

    public static <T> String join(Collection<? extends T> elements, BiConsumer<? super T, StringBuilder> consumer, String delimiter) {
        StringBuilder builder = new StringBuilder();
        Texts.join(builder, elements, consumer, delimiter);
        return builder.toString();
    }

    public static <T> void join(StringBuilder builder, Collection<? extends T> elements, BiConsumer<? super T, StringBuilder> consumer, String delimiter) {
        int i = 0;
        for (T element : elements) {
            consumer.accept(element, builder);
            if (i < elements.size() - 1) {
                builder.append(delimiter);
            }
            ++i;
        }
    }

    public static <T> String join(T[] elements, BiConsumer<? super T, StringBuilder> consumer, String delimiter) {
        StringBuilder builder = new StringBuilder();
        Texts.join(builder, elements, consumer, delimiter);
        return builder.toString();
    }

    public static <T> void join(StringBuilder builder, T[] elements, BiConsumer<? super T, StringBuilder> consumer, String delimiter) {
        for (int i = 0; i < elements.length; ++i) {
            consumer.accept(elements[i], builder);
            if (i >= elements.length - 1) continue;
            builder.append(delimiter);
        }
    }

    public static String join(String left, String delimiter, String right) {
        if (left.isBlank()) {
            return right;
        }
        if (right.isBlank()) {
            return left;
        }
        return left + delimiter + right;
    }

    public static Modifier[] sort(Collection<Modifier> modifiers) {
        return Texts.sort((Modifier[])modifiers.toArray(Modifier[]::new));
    }

    public static Modifier[] sort(Modifier ... modifiers) {
        Arrays.sort(modifiers, (a, b) -> Integer.compare(Texts.order(a), Texts.order(b)));
        return modifiers;
    }

    static int order(Modifier modifier) {
        switch (modifier) {
            case PUBLIC: 
            case PROTECTED: 
            case PRIVATE: {
                return 0;
            }
            case STATIC: {
                return 1;
            }
            case ABSTRACT: {
                return 2;
            }
            case FINAL: {
                return 2;
            }
        }
        return 3;
    }
}

