/*
 * Decompiled with CFR 0.152.
 */
package com.karuslabs.utilitary.snippet;

import com.karuslabs.utilitary.Texts;
import com.karuslabs.utilitary.snippet.Line;
import com.karuslabs.utilitary.snippet.VariableLine;
import com.karuslabs.utilitary.type.TypeMirrors;
import com.karuslabs.utilitary.type.TypePrinter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeMirror;

public class Part<T, U extends Line>
extends Line {
    public final Map<T, U> values;

    public static Part<AnnotationMirror, Line> annotations(List<? extends AnnotationMirror> annotations, int column, int position) {
        LinkedHashMap<AnnotationMirror, Line> values = new LinkedHashMap<AnnotationMirror, Line>();
        StringBuilder builder = new StringBuilder();
        for (AnnotationMirror annotationMirror : annotations) {
            Line line = Part.annotation(annotationMirror, column, position + builder.length());
            values.put(annotationMirror, line);
            builder.append(line).append(" ");
        }
        return new Part<AnnotationMirror, Line>(values, builder.toString(), column, position);
    }

    public static Part<Modifier, Line> modifiers(Set<Modifier> modifiers, int column, int position) {
        LinkedHashMap<Modifier, Line> values = new LinkedHashMap<Modifier, Line>();
        StringBuilder builder = new StringBuilder();
        for (Modifier modifier : Texts.sort(modifiers)) {
            Line line = new Line(modifier.toString(), column, position + builder.length());
            values.put(modifier, line);
            builder.append(line).append(' ');
        }
        return new Part<Modifier, Line>(values, builder.toString(), column, position);
    }

    public static Part<TypeParameterElement, Line> typeParameters(List<? extends TypeParameterElement> parameters, int column, int position) {
        if (parameters.isEmpty()) {
            return new Part<TypeParameterElement, Line>(Map.of(), "", column, position);
        }
        LinkedHashMap arguments = new LinkedHashMap();
        StringBuilder builder = new StringBuilder().append("<");
        Texts.join(builder, parameters, (parameter, sb) -> {
            Line line = new Line(TypePrinter.simple(parameter.asType()), column, position + builder.length());
            arguments.put(parameter, line);
            builder.append(line);
        }, ", ");
        return new Part<TypeParameterElement, Line>(arguments, builder.append(">").toString(), column, position);
    }

    public static Part<VariableElement, VariableLine> parameters(List<? extends VariableElement> variables, int column, int position) {
        StringBuilder builder = new StringBuilder();
        LinkedHashMap values = new LinkedHashMap();
        builder.append('(');
        Texts.join(builder, variables, (variable, sb) -> {
            VariableLine value = VariableLine.of(variable, column, position + sb.length());
            values.put(variable, value);
            sb.append(value);
        }, ", ");
        builder.append(')');
        return new Part<VariableElement, VariableLine>(values, builder.toString(), column, position);
    }

    public static Part<TypeMirror, Line> exceptions(List<? extends TypeMirror> types, int column, int position) {
        if (types.isEmpty()) {
            return new Part<TypeMirror, Line>(Map.of(), "", column, position);
        }
        LinkedHashMap values = new LinkedHashMap();
        StringBuilder builder = new StringBuilder().append(" throws ");
        Texts.join(builder, types, (type, sb) -> {
            Line line = new Line(TypePrinter.simple(type), column, position + sb.length());
            values.put(type, line);
            sb.append(line);
        }, ", ");
        return new Part<TypeMirror, Line>(values, builder.toString(), column, position);
    }

    public static Part<TypeMirror, Line> extend(TypeMirror supertype, int column, int position) {
        if (supertype instanceof NoType || TypeMirrors.is(supertype, Object.class)) {
            return new Part<TypeMirror, Line>(Map.of(), "", column, position);
        }
        String extend = " extends ";
        Line type = new Line(TypePrinter.simple(supertype), column, position + extend.length());
        return new Part<TypeMirror, Line>(Map.of(supertype, type), extend + type, column, position);
    }

    public static Part<TypeMirror, Line> implement(ElementKind kind, List<? extends TypeMirror> interfaces, int column, int position) {
        if (interfaces.isEmpty()) {
            return new Part<TypeMirror, Line>(Map.of(), "", column, position);
        }
        LinkedHashMap values = new LinkedHashMap();
        StringBuilder builder = new StringBuilder().append(kind == ElementKind.INTERFACE ? " extends " : " implements ");
        Texts.join(builder, interfaces, (type, sb) -> {
            Line line = new Line(TypePrinter.simple(type), column, position + sb.length());
            values.put(type, line);
            sb.append(line);
        }, ", ");
        return new Part<TypeMirror, Line>(values, builder.toString(), column, position);
    }

    Part(Map<T, U> values, String line, int column, int position) {
        super(line, column, position);
        this.values = values;
    }
}

