/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.acs.v1.resource;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Jsons;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.acs.v1.model.GetUserFaceReq;
import com.lark.oapi.service.acs.v1.model.GetUserFaceResp;
import com.lark.oapi.service.acs.v1.model.UpdateUserFaceReq;
import com.lark.oapi.service.acs.v1.model.UpdateUserFaceResp;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserFace {
    private static final Logger log = LoggerFactory.getLogger(UserFace.class);
    private final Config config;

    public UserFace(Config config) {
        this.config = config;
    }

    public GetUserFaceResp get(GetUserFaceReq req, RequestOptions reqOptions) throws Exception {
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }
        reqOptions.setSupportDownLoad(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/acs/v1/users/:user_id/face", Sets.newHashSet(AccessTokenType.Tenant), req);
        if (httpResponse.getStatusCode() == 200) {
            GetUserFaceResp resp = new GetUserFaceResp();
            resp.setRawResponse(httpResponse);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            outputStream.write(httpResponse.getBody());
            resp.setData(outputStream);
            resp.setFileName(httpResponse.getFileName());
            return resp;
        }
        GetUserFaceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetUserFaceResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/acs/v1/users/:user_id/face", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public GetUserFaceResp get(GetUserFaceReq req) throws Exception {
        RequestOptions reqOptions = new RequestOptions();
        reqOptions.setSupportDownLoad(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/acs/v1/users/:user_id/face", Sets.newHashSet(AccessTokenType.Tenant), req);
        if (httpResponse.getStatusCode() == 200) {
            GetUserFaceResp resp = new GetUserFaceResp();
            resp.setRawResponse(httpResponse);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            outputStream.write(httpResponse.getBody());
            resp.setData(outputStream);
            resp.setFileName(httpResponse.getFileName());
            return resp;
        }
        GetUserFaceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetUserFaceResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/acs/v1/users/:user_id/face", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public UpdateUserFaceResp update(UpdateUserFaceReq req, RequestOptions reqOptions) throws Exception {
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }
        reqOptions.setSupportUpload(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "PUT", "/open-apis/acs/v1/users/:user_id/face", Sets.newHashSet(AccessTokenType.Tenant), req);
        UpdateUserFaceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UpdateUserFaceResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/acs/v1/users/:user_id/face", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public UpdateUserFaceResp update(UpdateUserFaceReq req) throws Exception {
        RequestOptions reqOptions = new RequestOptions();
        reqOptions.setSupportUpload(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "PUT", "/open-apis/acs/v1/users/:user_id/face", Sets.newHashSet(AccessTokenType.Tenant), req);
        UpdateUserFaceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UpdateUserFaceResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/acs/v1/users/:user_id/face", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }
}

