// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.aily.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.aily.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;

import java.util.Map;

import com.lark.oapi.core.response.BaseResponse;

public class Table {
    /**
     * 表类型，分为 "datatable"、"dataset"
     * <p> 示例值：datatable
     */
    @SerializedName("table_type")
    private String tableType;
    /**
     * 数据表标识
     * <p> 示例值：object_a
     */
    @SerializedName("api_name")
    private String apiName;
    /**
     * 数据表名称
     * <p> 示例值：
     */
    @SerializedName("label")
    private Map<String, String> label;
    /**
     * 数据表读写权限
     * <p> 示例值：
     */
    @SerializedName("access_items")
    private String[] accessItems;
    /**
     * 数据表描述信息
     * <p> 示例值：这是一个商品的数据表
     */
    @SerializedName("ai_description")
    private String aiDescription;
    /**
     * 数据表下的字段列表，获取数据表元信息详情时才会返回
     * <p> 示例值：
     */
    @SerializedName("fields")
    private Field[] fields;

    // builder 开始
    public Table() {
    }

    public Table(Builder builder) {
        /**
         * 表类型，分为 "datatable"、"dataset"
         * <p> 示例值：datatable
         */
        this.tableType = builder.tableType;
        /**
         * 数据表标识
         * <p> 示例值：object_a
         */
        this.apiName = builder.apiName;
        /**
         * 数据表名称
         * <p> 示例值：
         */
        this.label = builder.label;
        /**
         * 数据表读写权限
         * <p> 示例值：
         */
        this.accessItems = builder.accessItems;
        /**
         * 数据表描述信息
         * <p> 示例值：这是一个商品的数据表
         */
        this.aiDescription = builder.aiDescription;
        /**
         * 数据表下的字段列表，获取数据表元信息详情时才会返回
         * <p> 示例值：
         */
        this.fields = builder.fields;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getTableType() {
        return this.tableType;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public String getApiName() {
        return this.apiName;
    }

    public void setApiName(String apiName) {
        this.apiName = apiName;
    }

    public Map<String, String> getLabel() {
        return this.label;
    }

    public void setLabel(Map<String, String> label) {
        this.label = label;
    }

    public String[] getAccessItems() {
        return this.accessItems;
    }

    public void setAccessItems(String[] accessItems) {
        this.accessItems = accessItems;
    }

    public String getAiDescription() {
        return this.aiDescription;
    }

    public void setAiDescription(String aiDescription) {
        this.aiDescription = aiDescription;
    }

    public Field[] getFields() {
        return this.fields;
    }

    public void setFields(Field[] fields) {
        this.fields = fields;
    }

    public static class Builder {
        /**
         * 表类型，分为 "datatable"、"dataset"
         * <p> 示例值：datatable
         */
        private String tableType;
        /**
         * 数据表标识
         * <p> 示例值：object_a
         */
        private String apiName;
        /**
         * 数据表名称
         * <p> 示例值：
         */
        private Map<String, String> label;
        /**
         * 数据表读写权限
         * <p> 示例值：
         */
        private String[] accessItems;
        /**
         * 数据表描述信息
         * <p> 示例值：这是一个商品的数据表
         */
        private String aiDescription;
        /**
         * 数据表下的字段列表，获取数据表元信息详情时才会返回
         * <p> 示例值：
         */
        private Field[] fields;

        /**
         * 表类型，分为 "datatable"、"dataset"
         * <p> 示例值：datatable
         *
         * @param tableType
         * @return
         */
        public Builder tableType(String tableType) {
            this.tableType = tableType;
            return this;
        }

        /**
         * 表类型，分为 "datatable"、"dataset"
         * <p> 示例值：datatable
         *
         * @param tableType {@link com.lark.oapi.service.aily.v1.enums.TableTableTypeEnum}
         * @return
         */
        public Builder tableType(com.lark.oapi.service.aily.v1.enums.TableTableTypeEnum tableType) {
            this.tableType = tableType.getValue();
            return this;
        }


        /**
         * 数据表标识
         * <p> 示例值：object_a
         *
         * @param apiName
         * @return
         */
        public Builder apiName(String apiName) {
            this.apiName = apiName;
            return this;
        }


        /**
         * 数据表名称
         * <p> 示例值：
         *
         * @param label
         * @return
         */
        public Builder label(Map<String, String> label) {
            this.label = label;
            return this;
        }


        /**
         * 数据表读写权限
         * <p> 示例值：
         *
         * @param accessItems
         * @return
         */
        public Builder accessItems(String[] accessItems) {
            this.accessItems = accessItems;
            return this;
        }


        /**
         * 数据表描述信息
         * <p> 示例值：这是一个商品的数据表
         *
         * @param aiDescription
         * @return
         */
        public Builder aiDescription(String aiDescription) {
            this.aiDescription = aiDescription;
            return this;
        }


        /**
         * 数据表下的字段列表，获取数据表元信息详情时才会返回
         * <p> 示例值：
         *
         * @param fields
         * @return
         */
        public Builder fields(Field[] fields) {
            this.fields = fields;
            return this;
        }


        public Table build() {
            return new Table(this);
        }
    }
}
