// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.bitable.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.bitable.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class DisplayApp {
    /**
     * 多维表格的 app_token;[app_token 参数说明](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/bitable/notification#8121eebe)
     * <p> 示例值：
     */
    @SerializedName("app_token")
    private String appToken;
    /**
     * 多维表格的名字
     * <p> 示例值：
     */
    @SerializedName("name")
    private String name;
    /**
     * 多维表格的版本号（对多维表格进行修改时更新，如新增、删除数据表，修改数据表名等，初始为1，每次更新+1）
     * <p> 示例值：
     */
    @SerializedName("revision")
    private Integer revision;
    /**
     * 多维表格是否开启了高级权限。取值包括：;- true：表示开启了高级权限;- false：表示关闭了高级权限;;[了解更多：使用多维表格高级权限](https://www.feishu.cn/hc/zh-CN/articles/588604550568)
     * <p> 示例值：
     */
    @SerializedName("is_advanced")
    private Boolean isAdvanced;
    /**
     * 文档时区
     * <p> 示例值：
     */
    @SerializedName("time_zone")
    private String timeZone;

    // builder 开始
    public DisplayApp() {
    }

    public DisplayApp(Builder builder) {
        /**
         * 多维表格的 app_token;[app_token 参数说明](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/bitable/notification#8121eebe)
         * <p> 示例值：
         */
        this.appToken = builder.appToken;
        /**
         * 多维表格的名字
         * <p> 示例值：
         */
        this.name = builder.name;
        /**
         * 多维表格的版本号（对多维表格进行修改时更新，如新增、删除数据表，修改数据表名等，初始为1，每次更新+1）
         * <p> 示例值：
         */
        this.revision = builder.revision;
        /**
         * 多维表格是否开启了高级权限。取值包括：;- true：表示开启了高级权限;- false：表示关闭了高级权限;;[了解更多：使用多维表格高级权限](https://www.feishu.cn/hc/zh-CN/articles/588604550568)
         * <p> 示例值：
         */
        this.isAdvanced = builder.isAdvanced;
        /**
         * 文档时区
         * <p> 示例值：
         */
        this.timeZone = builder.timeZone;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getAppToken() {
        return this.appToken;
    }

    public void setAppToken(String appToken) {
        this.appToken = appToken;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getRevision() {
        return this.revision;
    }

    public void setRevision(Integer revision) {
        this.revision = revision;
    }

    public Boolean getIsAdvanced() {
        return this.isAdvanced;
    }

    public void setIsAdvanced(Boolean isAdvanced) {
        this.isAdvanced = isAdvanced;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public static class Builder {
        /**
         * 多维表格的 app_token;[app_token 参数说明](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/bitable/notification#8121eebe)
         * <p> 示例值：
         */
        private String appToken;
        /**
         * 多维表格的名字
         * <p> 示例值：
         */
        private String name;
        /**
         * 多维表格的版本号（对多维表格进行修改时更新，如新增、删除数据表，修改数据表名等，初始为1，每次更新+1）
         * <p> 示例值：
         */
        private Integer revision;
        /**
         * 多维表格是否开启了高级权限。取值包括：;- true：表示开启了高级权限;- false：表示关闭了高级权限;;[了解更多：使用多维表格高级权限](https://www.feishu.cn/hc/zh-CN/articles/588604550568)
         * <p> 示例值：
         */
        private Boolean isAdvanced;
        /**
         * 文档时区
         * <p> 示例值：
         */
        private String timeZone;

        /**
         * 多维表格的 app_token;[app_token 参数说明](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/bitable/notification#8121eebe)
         * <p> 示例值：
         *
         * @param appToken
         * @return
         */
        public Builder appToken(String appToken) {
            this.appToken = appToken;
            return this;
        }


        /**
         * 多维表格的名字
         * <p> 示例值：
         *
         * @param name
         * @return
         */
        public Builder name(String name) {
            this.name = name;
            return this;
        }


        /**
         * 多维表格的版本号（对多维表格进行修改时更新，如新增、删除数据表，修改数据表名等，初始为1，每次更新+1）
         * <p> 示例值：
         *
         * @param revision
         * @return
         */
        public Builder revision(Integer revision) {
            this.revision = revision;
            return this;
        }


        /**
         * 多维表格是否开启了高级权限。取值包括：;- true：表示开启了高级权限;- false：表示关闭了高级权限;;[了解更多：使用多维表格高级权限](https://www.feishu.cn/hc/zh-CN/articles/588604550568)
         * <p> 示例值：
         *
         * @param isAdvanced
         * @return
         */
        public Builder isAdvanced(Boolean isAdvanced) {
            this.isAdvanced = isAdvanced;
            return this;
        }


        /**
         * 文档时区
         * <p> 示例值：
         *
         * @param timeZone
         * @return
         */
        public Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }


        public DisplayApp build() {
            return new DisplayApp(this);
        }
    }
}
