// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.contact.v3.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.contact.v3.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class NotificationOption {
    /**
     * 通道列表
     * <p> 示例值：["sms", "email"]
     */
    @SerializedName("channels")
    private String[] channels;
    /**
     * 语言类型
     * <p> 示例值：zh-CN
     */
    @SerializedName("language")
    private String language;

    // builder 开始
    public NotificationOption() {
    }

    public NotificationOption(Builder builder) {
        /**
         * 通道列表
         * <p> 示例值：["sms", "email"]
         */
        this.channels = builder.channels;
        /**
         * 语言类型
         * <p> 示例值：zh-CN
         */
        this.language = builder.language;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String[] getChannels() {
        return this.channels;
    }

    public void setChannels(String[] channels) {
        this.channels = channels;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public static class Builder {
        /**
         * 通道列表
         * <p> 示例值：["sms", "email"]
         */
        private String[] channels;
        /**
         * 语言类型
         * <p> 示例值：zh-CN
         */
        private String language;

        /**
         * 通道列表
         * <p> 示例值：["sms", "email"]
         *
         * @param channels
         * @return
         */
        public Builder channels(String[] channels) {
            this.channels = channels;
            return this;
        }


        /**
         * 语言类型
         * <p> 示例值：zh-CN
         *
         * @param language
         * @return
         */
        public Builder language(String language) {
            this.language = language;
            return this;
        }

        /**
         * 语言类型
         * <p> 示例值：zh-CN
         *
         * @param language {@link com.lark.oapi.service.contact.v3.enums.NotificationOptionLanguageEnum}
         * @return
         */
        public Builder language(com.lark.oapi.service.contact.v3.enums.NotificationOptionLanguageEnum language) {
            this.language = language.getValue();
            return this;
        }


        public NotificationOption build() {
            return new NotificationOption(this);
        }
    }
}
