// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.corehr.v2.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.corehr.v2.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class BatchGetDepartmentReqBody {
    /**
     * 部门 ID 列表
     * <p> 示例值：
     */
    @SerializedName("department_id_list")
    private String[] departmentIdList;
    /**
     * 返回数据的字段列表
     * <p> 示例值：
     */
    @SerializedName("fields")
    private String[] fields;
    /**
     * 部门名称精确匹配，最多传100个
     * <p> 示例值：
     */
    @SerializedName("department_name_list")
    private String[] departmentNameList;

    // builder 开始
    public BatchGetDepartmentReqBody() {
    }

    public BatchGetDepartmentReqBody(Builder builder) {
        /**
         * 部门 ID 列表
         * <p> 示例值：
         */
        this.departmentIdList = builder.departmentIdList;
        /**
         * 返回数据的字段列表
         * <p> 示例值：
         */
        this.fields = builder.fields;
        /**
         * 部门名称精确匹配，最多传100个
         * <p> 示例值：
         */
        this.departmentNameList = builder.departmentNameList;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String[] getDepartmentIdList() {
        return this.departmentIdList;
    }

    public void setDepartmentIdList(String[] departmentIdList) {
        this.departmentIdList = departmentIdList;
    }

    public String[] getFields() {
        return this.fields;
    }

    public void setFields(String[] fields) {
        this.fields = fields;
    }

    public String[] getDepartmentNameList() {
        return this.departmentNameList;
    }

    public void setDepartmentNameList(String[] departmentNameList) {
        this.departmentNameList = departmentNameList;
    }

    public static class Builder {
        /**
         * 部门 ID 列表
         * <p> 示例值：
         */
        private String[] departmentIdList;
        /**
         * 返回数据的字段列表
         * <p> 示例值：
         */
        private String[] fields;
        /**
         * 部门名称精确匹配，最多传100个
         * <p> 示例值：
         */
        private String[] departmentNameList;

        /**
         * 部门 ID 列表
         * <p> 示例值：
         *
         * @param departmentIdList
         * @return
         */
        public Builder departmentIdList(String[] departmentIdList) {
            this.departmentIdList = departmentIdList;
            return this;
        }


        /**
         * 返回数据的字段列表
         * <p> 示例值：
         *
         * @param fields
         * @return
         */
        public Builder fields(String[] fields) {
            this.fields = fields;
            return this;
        }


        /**
         * 部门名称精确匹配，最多传100个
         * <p> 示例值：
         *
         * @param departmentNameList
         * @return
         */
        public Builder departmentNameList(String[] departmentNameList) {
            this.departmentNameList = departmentNameList;
            return this;
        }


        public BatchGetDepartmentReqBody build() {
            return new BatchGetDepartmentReqBody(this);
        }
    }
}
