// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.corehr.v2.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.corehr.v2.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class District {
    /**
     * 区/县 ID
     * <p> 示例值：6863333353496512007
     */
    @SerializedName("district_id")
    private String districtId;
    /**
     * 名称
     * <p> 示例值：
     */
    @SerializedName("name")
    private I18n[] name;
    /**
     * 所属城市 ID，详细信息可通过[查询城市信息](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/corehr-v2/basic_info-city/search)接口获得
     * <p> 示例值：6863333352603125255
     */
    @SerializedName("city_id")
    private String cityId;
    /**
     * 行政区划代码
     * <p> 示例值：230110
     */
    @SerializedName("subregion_code")
    private String subregionCode;
    /**
     * 状态
     * <p> 示例值：1
     */
    @SerializedName("status")
    private Integer status;

    // builder 开始
    public District() {
    }

    public District(Builder builder) {
        /**
         * 区/县 ID
         * <p> 示例值：6863333353496512007
         */
        this.districtId = builder.districtId;
        /**
         * 名称
         * <p> 示例值：
         */
        this.name = builder.name;
        /**
         * 所属城市 ID，详细信息可通过[查询城市信息](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/corehr-v2/basic_info-city/search)接口获得
         * <p> 示例值：6863333352603125255
         */
        this.cityId = builder.cityId;
        /**
         * 行政区划代码
         * <p> 示例值：230110
         */
        this.subregionCode = builder.subregionCode;
        /**
         * 状态
         * <p> 示例值：1
         */
        this.status = builder.status;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getDistrictId() {
        return this.districtId;
    }

    public void setDistrictId(String districtId) {
        this.districtId = districtId;
    }

    public I18n[] getName() {
        return this.name;
    }

    public void setName(I18n[] name) {
        this.name = name;
    }

    public String getCityId() {
        return this.cityId;
    }

    public void setCityId(String cityId) {
        this.cityId = cityId;
    }

    public String getSubregionCode() {
        return this.subregionCode;
    }

    public void setSubregionCode(String subregionCode) {
        this.subregionCode = subregionCode;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public static class Builder {
        /**
         * 区/县 ID
         * <p> 示例值：6863333353496512007
         */
        private String districtId;
        /**
         * 名称
         * <p> 示例值：
         */
        private I18n[] name;
        /**
         * 所属城市 ID，详细信息可通过[查询城市信息](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/corehr-v2/basic_info-city/search)接口获得
         * <p> 示例值：6863333352603125255
         */
        private String cityId;
        /**
         * 行政区划代码
         * <p> 示例值：230110
         */
        private String subregionCode;
        /**
         * 状态
         * <p> 示例值：1
         */
        private Integer status;

        /**
         * 区/县 ID
         * <p> 示例值：6863333353496512007
         *
         * @param districtId
         * @return
         */
        public Builder districtId(String districtId) {
            this.districtId = districtId;
            return this;
        }


        /**
         * 名称
         * <p> 示例值：
         *
         * @param name
         * @return
         */
        public Builder name(I18n[] name) {
            this.name = name;
            return this;
        }


        /**
         * 所属城市 ID，详细信息可通过[查询城市信息](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/corehr-v2/basic_info-city/search)接口获得
         * <p> 示例值：6863333352603125255
         *
         * @param cityId
         * @return
         */
        public Builder cityId(String cityId) {
            this.cityId = cityId;
            return this;
        }


        /**
         * 行政区划代码
         * <p> 示例值：230110
         *
         * @param subregionCode
         * @return
         */
        public Builder subregionCode(String subregionCode) {
            this.subregionCode = subregionCode;
            return this;
        }


        /**
         * 状态
         * <p> 示例值：1
         *
         * @param status
         * @return
         */
        public Builder status(Integer status) {
            this.status = status;
            return this;
        }

        /**
         * 状态
         * <p> 示例值：1
         *
         * @param status {@link com.lark.oapi.service.corehr.v2.enums.DistrictBasicDataObjStatusEnum}
         * @return
         */
        public Builder status(com.lark.oapi.service.corehr.v2.enums.DistrictBasicDataObjStatusEnum status) {
            this.status = status.getValue();
            return this;
        }


        public District build() {
            return new District(this);
        }
    }
}
