// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.hire.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class BatchGetIdTalentReqBody {
    /**
     * 手机国家区号，默认值：86，即中国大陆地区
     * <p> 示例值：86
     */
    @SerializedName("mobile_code")
    private String mobileCode;
    /**
     * 手机号，区号均采用 mobile_code 参数的值，最多 100 个
     * <p> 示例值：182900291190
     */
    @SerializedName("mobile_number_list")
    private String[] mobileNumberList;
    /**
     * 邮箱信息列表，最多 100 个
     * <p> 示例值：foo@bytedance.com
     */
    @SerializedName("email_list")
    private String[] emailList;
    /**
     * 证件类型，可参考招聘枚举常量文档下的 IdentificationType 枚举定义
     * <p> 示例值：1
     */
    @SerializedName("identification_type")
    private Integer identificationType;
    /**
     * 证件号
     * <p> 示例值：130xxxxxxx
     */
    @SerializedName("identification_number_list")
    private String[] identificationNumberList;

    // builder 开始
    public BatchGetIdTalentReqBody() {
    }

    public BatchGetIdTalentReqBody(Builder builder) {
        /**
         * 手机国家区号，默认值：86，即中国大陆地区
         * <p> 示例值：86
         */
        this.mobileCode = builder.mobileCode;
        /**
         * 手机号，区号均采用 mobile_code 参数的值，最多 100 个
         * <p> 示例值：182900291190
         */
        this.mobileNumberList = builder.mobileNumberList;
        /**
         * 邮箱信息列表，最多 100 个
         * <p> 示例值：foo@bytedance.com
         */
        this.emailList = builder.emailList;
        /**
         * 证件类型，可参考招聘枚举常量文档下的 IdentificationType 枚举定义
         * <p> 示例值：1
         */
        this.identificationType = builder.identificationType;
        /**
         * 证件号
         * <p> 示例值：130xxxxxxx
         */
        this.identificationNumberList = builder.identificationNumberList;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getMobileCode() {
        return this.mobileCode;
    }

    public void setMobileCode(String mobileCode) {
        this.mobileCode = mobileCode;
    }

    public String[] getMobileNumberList() {
        return this.mobileNumberList;
    }

    public void setMobileNumberList(String[] mobileNumberList) {
        this.mobileNumberList = mobileNumberList;
    }

    public String[] getEmailList() {
        return this.emailList;
    }

    public void setEmailList(String[] emailList) {
        this.emailList = emailList;
    }

    public Integer getIdentificationType() {
        return this.identificationType;
    }

    public void setIdentificationType(Integer identificationType) {
        this.identificationType = identificationType;
    }

    public String[] getIdentificationNumberList() {
        return this.identificationNumberList;
    }

    public void setIdentificationNumberList(String[] identificationNumberList) {
        this.identificationNumberList = identificationNumberList;
    }

    public static class Builder {
        /**
         * 手机国家区号，默认值：86，即中国大陆地区
         * <p> 示例值：86
         */
        private String mobileCode;
        /**
         * 手机号，区号均采用 mobile_code 参数的值，最多 100 个
         * <p> 示例值：182900291190
         */
        private String[] mobileNumberList;
        /**
         * 邮箱信息列表，最多 100 个
         * <p> 示例值：foo@bytedance.com
         */
        private String[] emailList;
        /**
         * 证件类型，可参考招聘枚举常量文档下的 IdentificationType 枚举定义
         * <p> 示例值：1
         */
        private Integer identificationType;
        /**
         * 证件号
         * <p> 示例值：130xxxxxxx
         */
        private String[] identificationNumberList;

        /**
         * 手机国家区号，默认值：86，即中国大陆地区
         * <p> 示例值：86
         *
         * @param mobileCode
         * @return
         */
        public Builder mobileCode(String mobileCode) {
            this.mobileCode = mobileCode;
            return this;
        }


        /**
         * 手机号，区号均采用 mobile_code 参数的值，最多 100 个
         * <p> 示例值：182900291190
         *
         * @param mobileNumberList
         * @return
         */
        public Builder mobileNumberList(String[] mobileNumberList) {
            this.mobileNumberList = mobileNumberList;
            return this;
        }


        /**
         * 邮箱信息列表，最多 100 个
         * <p> 示例值：foo@bytedance.com
         *
         * @param emailList
         * @return
         */
        public Builder emailList(String[] emailList) {
            this.emailList = emailList;
            return this;
        }


        /**
         * 证件类型，可参考招聘枚举常量文档下的 IdentificationType 枚举定义
         * <p> 示例值：1
         *
         * @param identificationType
         * @return
         */
        public Builder identificationType(Integer identificationType) {
            this.identificationType = identificationType;
            return this;
        }


        /**
         * 证件号
         * <p> 示例值：130xxxxxxx
         *
         * @param identificationNumberList
         * @return
         */
        public Builder identificationNumberList(String[] identificationNumberList) {
            this.identificationNumberList = identificationNumberList;
            return this;
        }


        public BatchGetIdTalentReqBody build() {
            return new BatchGetIdTalentReqBody(this);
        }
    }
}
