// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.hire.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class JobManager {
    /**
     * 职位 ID
     * <p> 示例值：1618209327096
     */
    @SerializedName("id")
    private String id;
    /**
     * 招聘负责人 ID，仅一位，可通过用户相关接口获取用户 ID
     * <p> 示例值：ou_efk39117c300506837def50545420c6a
     */
    @SerializedName("recruiter_id")
    private String recruiterId;
    /**
     * 用人经理 ID 列表
     * <p> 示例值：6960663240925956554
     */
    @SerializedName("hiring_manager_id_list")
    private String[] hiringManagerIdList;
    /**
     * 协助人 ID 列表
     * <p> 示例值：6960663240925956554
     */
    @SerializedName("assistant_id_list")
    private String[] assistantIdList;

    // builder 开始
    public JobManager() {
    }

    public JobManager(Builder builder) {
        /**
         * 职位 ID
         * <p> 示例值：1618209327096
         */
        this.id = builder.id;
        /**
         * 招聘负责人 ID，仅一位，可通过用户相关接口获取用户 ID
         * <p> 示例值：ou_efk39117c300506837def50545420c6a
         */
        this.recruiterId = builder.recruiterId;
        /**
         * 用人经理 ID 列表
         * <p> 示例值：6960663240925956554
         */
        this.hiringManagerIdList = builder.hiringManagerIdList;
        /**
         * 协助人 ID 列表
         * <p> 示例值：6960663240925956554
         */
        this.assistantIdList = builder.assistantIdList;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRecruiterId() {
        return this.recruiterId;
    }

    public void setRecruiterId(String recruiterId) {
        this.recruiterId = recruiterId;
    }

    public String[] getHiringManagerIdList() {
        return this.hiringManagerIdList;
    }

    public void setHiringManagerIdList(String[] hiringManagerIdList) {
        this.hiringManagerIdList = hiringManagerIdList;
    }

    public String[] getAssistantIdList() {
        return this.assistantIdList;
    }

    public void setAssistantIdList(String[] assistantIdList) {
        this.assistantIdList = assistantIdList;
    }

    public static class Builder {
        /**
         * 职位 ID
         * <p> 示例值：1618209327096
         */
        private String id;
        /**
         * 招聘负责人 ID，仅一位，可通过用户相关接口获取用户 ID
         * <p> 示例值：ou_efk39117c300506837def50545420c6a
         */
        private String recruiterId;
        /**
         * 用人经理 ID 列表
         * <p> 示例值：6960663240925956554
         */
        private String[] hiringManagerIdList;
        /**
         * 协助人 ID 列表
         * <p> 示例值：6960663240925956554
         */
        private String[] assistantIdList;

        /**
         * 职位 ID
         * <p> 示例值：1618209327096
         *
         * @param id
         * @return
         */
        public Builder id(String id) {
            this.id = id;
            return this;
        }


        /**
         * 招聘负责人 ID，仅一位，可通过用户相关接口获取用户 ID
         * <p> 示例值：ou_efk39117c300506837def50545420c6a
         *
         * @param recruiterId
         * @return
         */
        public Builder recruiterId(String recruiterId) {
            this.recruiterId = recruiterId;
            return this;
        }


        /**
         * 用人经理 ID 列表
         * <p> 示例值：6960663240925956554
         *
         * @param hiringManagerIdList
         * @return
         */
        public Builder hiringManagerIdList(String[] hiringManagerIdList) {
            this.hiringManagerIdList = hiringManagerIdList;
            return this;
        }


        /**
         * 协助人 ID 列表
         * <p> 示例值：6960663240925956554
         *
         * @param assistantIdList
         * @return
         */
        public Builder assistantIdList(String[] assistantIdList) {
            this.assistantIdList = assistantIdList;
            return this;
        }


        public JobManager build() {
            return new JobManager(this);
        }
    }
}
