// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.hire.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class PermissionCollection {
    /**
     * 功能权限
     * <p> 示例值：
     */
    @SerializedName("feature_permissions")
    private IdNameObject[] featurePermissions;
    /**
     * 管理权限
     * <p> 示例值：
     */
    @SerializedName("management_permissions")
    private IdNameObject[] managementPermissions;
    /**
     * 数据权限
     * <p> 示例值：
     */
    @SerializedName("data_permissions")
    private DataPermission[] dataPermissions;
    /**
     * 业务管理范围
     * <p> 示例值：
     */
    @SerializedName("business_management_scopes")
    private BusinessManagementScope[] businessManagementScopes;

    // builder 开始
    public PermissionCollection() {
    }

    public PermissionCollection(Builder builder) {
        /**
         * 功能权限
         * <p> 示例值：
         */
        this.featurePermissions = builder.featurePermissions;
        /**
         * 管理权限
         * <p> 示例值：
         */
        this.managementPermissions = builder.managementPermissions;
        /**
         * 数据权限
         * <p> 示例值：
         */
        this.dataPermissions = builder.dataPermissions;
        /**
         * 业务管理范围
         * <p> 示例值：
         */
        this.businessManagementScopes = builder.businessManagementScopes;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public IdNameObject[] getFeaturePermissions() {
        return this.featurePermissions;
    }

    public void setFeaturePermissions(IdNameObject[] featurePermissions) {
        this.featurePermissions = featurePermissions;
    }

    public IdNameObject[] getManagementPermissions() {
        return this.managementPermissions;
    }

    public void setManagementPermissions(IdNameObject[] managementPermissions) {
        this.managementPermissions = managementPermissions;
    }

    public DataPermission[] getDataPermissions() {
        return this.dataPermissions;
    }

    public void setDataPermissions(DataPermission[] dataPermissions) {
        this.dataPermissions = dataPermissions;
    }

    public BusinessManagementScope[] getBusinessManagementScopes() {
        return this.businessManagementScopes;
    }

    public void setBusinessManagementScopes(BusinessManagementScope[] businessManagementScopes) {
        this.businessManagementScopes = businessManagementScopes;
    }

    public static class Builder {
        /**
         * 功能权限
         * <p> 示例值：
         */
        private IdNameObject[] featurePermissions;
        /**
         * 管理权限
         * <p> 示例值：
         */
        private IdNameObject[] managementPermissions;
        /**
         * 数据权限
         * <p> 示例值：
         */
        private DataPermission[] dataPermissions;
        /**
         * 业务管理范围
         * <p> 示例值：
         */
        private BusinessManagementScope[] businessManagementScopes;

        /**
         * 功能权限
         * <p> 示例值：
         *
         * @param featurePermissions
         * @return
         */
        public Builder featurePermissions(IdNameObject[] featurePermissions) {
            this.featurePermissions = featurePermissions;
            return this;
        }


        /**
         * 管理权限
         * <p> 示例值：
         *
         * @param managementPermissions
         * @return
         */
        public Builder managementPermissions(IdNameObject[] managementPermissions) {
            this.managementPermissions = managementPermissions;
            return this;
        }


        /**
         * 数据权限
         * <p> 示例值：
         *
         * @param dataPermissions
         * @return
         */
        public Builder dataPermissions(DataPermission[] dataPermissions) {
            this.dataPermissions = dataPermissions;
            return this;
        }


        /**
         * 业务管理范围
         * <p> 示例值：
         *
         * @param businessManagementScopes
         * @return
         */
        public Builder businessManagementScopes(BusinessManagementScope[] businessManagementScopes) {
            this.businessManagementScopes = businessManagementScopes;
            return this;
        }


        public PermissionCollection build() {
            return new PermissionCollection(this);
        }
    }
}
