// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.search.v2.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.search.v2.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class Schema {
    /**
     * 数据范式的属性定义
     * <p> 示例值：
     */
    @SerializedName("properties")
    private SchemaProperty[] properties;
    /**
     * 数据展示相关配置
     * <p> 示例值：
     */
    @SerializedName("display")
    private SchemaDisplay display;
    /**
     * 用户自定义数据范式的唯一标识
     * <p> 示例值：jira_schema
     */
    @SerializedName("schema_id")
    private String schemaId;

    // builder 开始
    public Schema() {
    }

    public Schema(Builder builder) {
        /**
         * 数据范式的属性定义
         * <p> 示例值：
         */
        this.properties = builder.properties;
        /**
         * 数据展示相关配置
         * <p> 示例值：
         */
        this.display = builder.display;
        /**
         * 用户自定义数据范式的唯一标识
         * <p> 示例值：jira_schema
         */
        this.schemaId = builder.schemaId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public SchemaProperty[] getProperties() {
        return this.properties;
    }

    public void setProperties(SchemaProperty[] properties) {
        this.properties = properties;
    }

    public SchemaDisplay getDisplay() {
        return this.display;
    }

    public void setDisplay(SchemaDisplay display) {
        this.display = display;
    }

    public String getSchemaId() {
        return this.schemaId;
    }

    public void setSchemaId(String schemaId) {
        this.schemaId = schemaId;
    }

    public static class Builder {
        /**
         * 数据范式的属性定义
         * <p> 示例值：
         */
        private SchemaProperty[] properties;
        /**
         * 数据展示相关配置
         * <p> 示例值：
         */
        private SchemaDisplay display;
        /**
         * 用户自定义数据范式的唯一标识
         * <p> 示例值：jira_schema
         */
        private String schemaId;

        /**
         * 数据范式的属性定义
         * <p> 示例值：
         *
         * @param properties
         * @return
         */
        public Builder properties(SchemaProperty[] properties) {
            this.properties = properties;
            return this;
        }


        /**
         * 数据展示相关配置
         * <p> 示例值：
         *
         * @param display
         * @return
         */
        public Builder display(SchemaDisplay display) {
            this.display = display;
            return this;
        }


        /**
         * 用户自定义数据范式的唯一标识
         * <p> 示例值：jira_schema
         *
         * @param schemaId
         * @return
         */
        public Builder schemaId(String schemaId) {
            this.schemaId = schemaId;
            return this;
        }


        public Schema build() {
            return new Schema(this);
        }
    }
}
