// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.security_and_compliance.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.security_and_compliance.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class FileRiskDetectionRecord {
    /**
     * 文件送检记录主键
     * <p> 示例值：308975127
     */
    @SerializedName("record_id")
    private String recordId;
    /**
     * 文件下载链接
     * <p> 示例值：https://example.com
     */
    @SerializedName("file_url")
    private String fileUrl;
    /**
     * 文件下载链接失效时间戳（秒）
     * <p> 示例值：1735660799
     */
    @SerializedName("file_url_expire_time")
    private String fileUrlExpireTime;
    /**
     * 文件大小（字节）
     * <p> 示例值：1024
     */
    @SerializedName("file_size")
    private String fileSize;
    /**
     * 触发送检原因
     * <p> 示例值：1
     */
    @SerializedName("trigger_reason")
    private Integer triggerReason;

    // builder 开始
    public FileRiskDetectionRecord() {
    }

    public FileRiskDetectionRecord(Builder builder) {
        /**
         * 文件送检记录主键
         * <p> 示例值：308975127
         */
        this.recordId = builder.recordId;
        /**
         * 文件下载链接
         * <p> 示例值：https://example.com
         */
        this.fileUrl = builder.fileUrl;
        /**
         * 文件下载链接失效时间戳（秒）
         * <p> 示例值：1735660799
         */
        this.fileUrlExpireTime = builder.fileUrlExpireTime;
        /**
         * 文件大小（字节）
         * <p> 示例值：1024
         */
        this.fileSize = builder.fileSize;
        /**
         * 触发送检原因
         * <p> 示例值：1
         */
        this.triggerReason = builder.triggerReason;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getRecordId() {
        return this.recordId;
    }

    public void setRecordId(String recordId) {
        this.recordId = recordId;
    }

    public String getFileUrl() {
        return this.fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public String getFileUrlExpireTime() {
        return this.fileUrlExpireTime;
    }

    public void setFileUrlExpireTime(String fileUrlExpireTime) {
        this.fileUrlExpireTime = fileUrlExpireTime;
    }

    public String getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(String fileSize) {
        this.fileSize = fileSize;
    }

    public Integer getTriggerReason() {
        return this.triggerReason;
    }

    public void setTriggerReason(Integer triggerReason) {
        this.triggerReason = triggerReason;
    }

    public static class Builder {
        /**
         * 文件送检记录主键
         * <p> 示例值：308975127
         */
        private String recordId;
        /**
         * 文件下载链接
         * <p> 示例值：https://example.com
         */
        private String fileUrl;
        /**
         * 文件下载链接失效时间戳（秒）
         * <p> 示例值：1735660799
         */
        private String fileUrlExpireTime;
        /**
         * 文件大小（字节）
         * <p> 示例值：1024
         */
        private String fileSize;
        /**
         * 触发送检原因
         * <p> 示例值：1
         */
        private Integer triggerReason;

        /**
         * 文件送检记录主键
         * <p> 示例值：308975127
         *
         * @param recordId
         * @return
         */
        public Builder recordId(String recordId) {
            this.recordId = recordId;
            return this;
        }


        /**
         * 文件下载链接
         * <p> 示例值：https://example.com
         *
         * @param fileUrl
         * @return
         */
        public Builder fileUrl(String fileUrl) {
            this.fileUrl = fileUrl;
            return this;
        }


        /**
         * 文件下载链接失效时间戳（秒）
         * <p> 示例值：1735660799
         *
         * @param fileUrlExpireTime
         * @return
         */
        public Builder fileUrlExpireTime(String fileUrlExpireTime) {
            this.fileUrlExpireTime = fileUrlExpireTime;
            return this;
        }


        /**
         * 文件大小（字节）
         * <p> 示例值：1024
         *
         * @param fileSize
         * @return
         */
        public Builder fileSize(String fileSize) {
            this.fileSize = fileSize;
            return this;
        }


        /**
         * 触发送检原因
         * <p> 示例值：1
         *
         * @param triggerReason
         * @return
         */
        public Builder triggerReason(Integer triggerReason) {
            this.triggerReason = triggerReason;
            return this;
        }

        /**
         * 触发送检原因
         * <p> 示例值：1
         *
         * @param triggerReason {@link com.lark.oapi.service.security_and_compliance.v1.enums.FileRiskDetectionRecordTriggerReasonEnum}
         * @return
         */
        public Builder triggerReason(com.lark.oapi.service.security_and_compliance.v1.enums.FileRiskDetectionRecordTriggerReasonEnum triggerReason) {
            this.triggerReason = triggerReason.getValue();
            return this;
        }


        public FileRiskDetectionRecord build() {
            return new FileRiskDetectionRecord(this);
        }
    }
}
