// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.sheets.v3.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.sheets.v3.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class FindReplaceResult {
    /**
     * 符合查找条件的单元格数组，不包含公式，例如["A1", "A2"...]
     * <p> 示例值：
     */
    @SerializedName("matched_cells")
    private String[] matchedCells;
    /**
     * 符合查找条件的含有公式的单元格数组，例如["B3", "H7"...]
     * <p> 示例值：
     */
    @SerializedName("matched_formula_cells")
    private String[] matchedFormulaCells;
    /**
     * 符合查找条件的总行数
     * <p> 示例值：2
     */
    @SerializedName("rows_count")
    private Integer rowsCount;

    // builder 开始
    public FindReplaceResult() {
    }

    public FindReplaceResult(Builder builder) {
        /**
         * 符合查找条件的单元格数组，不包含公式，例如["A1", "A2"...]
         * <p> 示例值：
         */
        this.matchedCells = builder.matchedCells;
        /**
         * 符合查找条件的含有公式的单元格数组，例如["B3", "H7"...]
         * <p> 示例值：
         */
        this.matchedFormulaCells = builder.matchedFormulaCells;
        /**
         * 符合查找条件的总行数
         * <p> 示例值：2
         */
        this.rowsCount = builder.rowsCount;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String[] getMatchedCells() {
        return this.matchedCells;
    }

    public void setMatchedCells(String[] matchedCells) {
        this.matchedCells = matchedCells;
    }

    public String[] getMatchedFormulaCells() {
        return this.matchedFormulaCells;
    }

    public void setMatchedFormulaCells(String[] matchedFormulaCells) {
        this.matchedFormulaCells = matchedFormulaCells;
    }

    public Integer getRowsCount() {
        return this.rowsCount;
    }

    public void setRowsCount(Integer rowsCount) {
        this.rowsCount = rowsCount;
    }

    public static class Builder {
        /**
         * 符合查找条件的单元格数组，不包含公式，例如["A1", "A2"...]
         * <p> 示例值：
         */
        private String[] matchedCells;
        /**
         * 符合查找条件的含有公式的单元格数组，例如["B3", "H7"...]
         * <p> 示例值：
         */
        private String[] matchedFormulaCells;
        /**
         * 符合查找条件的总行数
         * <p> 示例值：2
         */
        private Integer rowsCount;

        /**
         * 符合查找条件的单元格数组，不包含公式，例如["A1", "A2"...]
         * <p> 示例值：
         *
         * @param matchedCells
         * @return
         */
        public Builder matchedCells(String[] matchedCells) {
            this.matchedCells = matchedCells;
            return this;
        }


        /**
         * 符合查找条件的含有公式的单元格数组，例如["B3", "H7"...]
         * <p> 示例值：
         *
         * @param matchedFormulaCells
         * @return
         */
        public Builder matchedFormulaCells(String[] matchedFormulaCells) {
            this.matchedFormulaCells = matchedFormulaCells;
            return this;
        }


        /**
         * 符合查找条件的总行数
         * <p> 示例值：2
         *
         * @param rowsCount
         * @return
         */
        public Builder rowsCount(Integer rowsCount) {
            this.rowsCount = rowsCount;
            return this;
        }


        public FindReplaceResult build() {
            return new FindReplaceResult(this);
        }
    }
}
