// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.sheets.v3.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.sheets.v3.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class Sheet {
    /**
     * 工作表id
     * <p> 示例值：sxj5ws
     */
    @SerializedName("sheet_id")
    private String sheetId;
    /**
     * 工作表标题
     * <p> 示例值：title
     */
    @SerializedName("title")
    private String title;
    /**
     * 工作表索引位置，索引从 0 开始计数。
     * <p> 示例值：0
     */
    @SerializedName("index")
    private Integer index;
    /**
     * 工作表是否被隐藏;- `true`：表示被隐藏;- `false`：表示未被隐藏
     * <p> 示例值：false
     */
    @SerializedName("hidden")
    private Boolean hidden;
    /**
     * 单元格属性
     * <p> 示例值：
     */
    @SerializedName("grid_properties")
    private GridProperties gridProperties;
    /**
     * 工作表类型;- `sheet`：工作表;- `bitable`：多维表格，[多维表格概述](https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/bitable-overview);- `#UNSUPPORTED_TYPE`：不支持的类型
     * <p> 示例值：sheet
     */
    @SerializedName("resource_type")
    private String resourceType;
    /**
     * 合并单元格的相关信息
     * <p> 示例值：
     */
    @SerializedName("merges")
    private MergeRange[] merges;

    // builder 开始
    public Sheet() {
    }

    public Sheet(Builder builder) {
        /**
         * 工作表id
         * <p> 示例值：sxj5ws
         */
        this.sheetId = builder.sheetId;
        /**
         * 工作表标题
         * <p> 示例值：title
         */
        this.title = builder.title;
        /**
         * 工作表索引位置，索引从 0 开始计数。
         * <p> 示例值：0
         */
        this.index = builder.index;
        /**
         * 工作表是否被隐藏;- `true`：表示被隐藏;- `false`：表示未被隐藏
         * <p> 示例值：false
         */
        this.hidden = builder.hidden;
        /**
         * 单元格属性
         * <p> 示例值：
         */
        this.gridProperties = builder.gridProperties;
        /**
         * 工作表类型;- `sheet`：工作表;- `bitable`：多维表格，[多维表格概述](https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/bitable-overview);- `#UNSUPPORTED_TYPE`：不支持的类型
         * <p> 示例值：sheet
         */
        this.resourceType = builder.resourceType;
        /**
         * 合并单元格的相关信息
         * <p> 示例值：
         */
        this.merges = builder.merges;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getSheetId() {
        return this.sheetId;
    }

    public void setSheetId(String sheetId) {
        this.sheetId = sheetId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public Boolean getHidden() {
        return this.hidden;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public GridProperties getGridProperties() {
        return this.gridProperties;
    }

    public void setGridProperties(GridProperties gridProperties) {
        this.gridProperties = gridProperties;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public MergeRange[] getMerges() {
        return this.merges;
    }

    public void setMerges(MergeRange[] merges) {
        this.merges = merges;
    }

    public static class Builder {
        /**
         * 工作表id
         * <p> 示例值：sxj5ws
         */
        private String sheetId;
        /**
         * 工作表标题
         * <p> 示例值：title
         */
        private String title;
        /**
         * 工作表索引位置，索引从 0 开始计数。
         * <p> 示例值：0
         */
        private Integer index;
        /**
         * 工作表是否被隐藏;- `true`：表示被隐藏;- `false`：表示未被隐藏
         * <p> 示例值：false
         */
        private Boolean hidden;
        /**
         * 单元格属性
         * <p> 示例值：
         */
        private GridProperties gridProperties;
        /**
         * 工作表类型;- `sheet`：工作表;- `bitable`：多维表格，[多维表格概述](https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/bitable-overview);- `#UNSUPPORTED_TYPE`：不支持的类型
         * <p> 示例值：sheet
         */
        private String resourceType;
        /**
         * 合并单元格的相关信息
         * <p> 示例值：
         */
        private MergeRange[] merges;

        /**
         * 工作表id
         * <p> 示例值：sxj5ws
         *
         * @param sheetId
         * @return
         */
        public Builder sheetId(String sheetId) {
            this.sheetId = sheetId;
            return this;
        }


        /**
         * 工作表标题
         * <p> 示例值：title
         *
         * @param title
         * @return
         */
        public Builder title(String title) {
            this.title = title;
            return this;
        }


        /**
         * 工作表索引位置，索引从 0 开始计数。
         * <p> 示例值：0
         *
         * @param index
         * @return
         */
        public Builder index(Integer index) {
            this.index = index;
            return this;
        }


        /**
         * 工作表是否被隐藏;- `true`：表示被隐藏;- `false`：表示未被隐藏
         * <p> 示例值：false
         *
         * @param hidden
         * @return
         */
        public Builder hidden(Boolean hidden) {
            this.hidden = hidden;
            return this;
        }


        /**
         * 单元格属性
         * <p> 示例值：
         *
         * @param gridProperties
         * @return
         */
        public Builder gridProperties(GridProperties gridProperties) {
            this.gridProperties = gridProperties;
            return this;
        }


        /**
         * 工作表类型;- `sheet`：工作表;- `bitable`：多维表格，[多维表格概述](https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/bitable-overview);- `#UNSUPPORTED_TYPE`：不支持的类型
         * <p> 示例值：sheet
         *
         * @param resourceType
         * @return
         */
        public Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }


        /**
         * 合并单元格的相关信息
         * <p> 示例值：
         *
         * @param merges
         * @return
         */
        public Builder merges(MergeRange[] merges) {
            this.merges = merges;
            return this;
        }


        public Sheet build() {
            return new Sheet(this);
        }
    }
}
