// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.vc.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.vc.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class MyAiAvPluginScenarioContext {
    /**
     * 会话选择的插件列表
     * <p> 示例值：
     */
    @SerializedName("plugins")
    private MyAiPluginContext[] plugins;
    /**
     * 会话所处的业务模式
     * <p> 示例值：1
     */
    @SerializedName("work_mode")
    private Integer workMode;
    /**
     * 会话所处的业务场景
     * <p> 示例值：MediaView
     */
    @SerializedName("scenario")
    private String scenario;
    /**
     * 会话ID
     * <p> 示例值：ssss
     */
    @SerializedName("session_id")
    private String sessionId;
    /**
     * upload objects
     * <p> 示例值：
     */
    @SerializedName("upload_objects")
    private MyAiAvPluginUploadObject[] uploadObjects;
    /**
     * system info
     * <p> 示例值：
     */
    @SerializedName("system_info")
    private MyAiAvPluginContextSystemInfo systemInfo;

    // builder 开始
    public MyAiAvPluginScenarioContext() {
    }

    public MyAiAvPluginScenarioContext(Builder builder) {
        /**
         * 会话选择的插件列表
         * <p> 示例值：
         */
        this.plugins = builder.plugins;
        /**
         * 会话所处的业务模式
         * <p> 示例值：1
         */
        this.workMode = builder.workMode;
        /**
         * 会话所处的业务场景
         * <p> 示例值：MediaView
         */
        this.scenario = builder.scenario;
        /**
         * 会话ID
         * <p> 示例值：ssss
         */
        this.sessionId = builder.sessionId;
        /**
         * upload objects
         * <p> 示例值：
         */
        this.uploadObjects = builder.uploadObjects;
        /**
         * system info
         * <p> 示例值：
         */
        this.systemInfo = builder.systemInfo;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public MyAiPluginContext[] getPlugins() {
        return this.plugins;
    }

    public void setPlugins(MyAiPluginContext[] plugins) {
        this.plugins = plugins;
    }

    public Integer getWorkMode() {
        return this.workMode;
    }

    public void setWorkMode(Integer workMode) {
        this.workMode = workMode;
    }

    public String getScenario() {
        return this.scenario;
    }

    public void setScenario(String scenario) {
        this.scenario = scenario;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public MyAiAvPluginUploadObject[] getUploadObjects() {
        return this.uploadObjects;
    }

    public void setUploadObjects(MyAiAvPluginUploadObject[] uploadObjects) {
        this.uploadObjects = uploadObjects;
    }

    public MyAiAvPluginContextSystemInfo getSystemInfo() {
        return this.systemInfo;
    }

    public void setSystemInfo(MyAiAvPluginContextSystemInfo systemInfo) {
        this.systemInfo = systemInfo;
    }

    public static class Builder {
        /**
         * 会话选择的插件列表
         * <p> 示例值：
         */
        private MyAiPluginContext[] plugins;
        /**
         * 会话所处的业务模式
         * <p> 示例值：1
         */
        private Integer workMode;
        /**
         * 会话所处的业务场景
         * <p> 示例值：MediaView
         */
        private String scenario;
        /**
         * 会话ID
         * <p> 示例值：ssss
         */
        private String sessionId;
        /**
         * upload objects
         * <p> 示例值：
         */
        private MyAiAvPluginUploadObject[] uploadObjects;
        /**
         * system info
         * <p> 示例值：
         */
        private MyAiAvPluginContextSystemInfo systemInfo;

        /**
         * 会话选择的插件列表
         * <p> 示例值：
         *
         * @param plugins
         * @return
         */
        public Builder plugins(MyAiPluginContext[] plugins) {
            this.plugins = plugins;
            return this;
        }


        /**
         * 会话所处的业务模式
         * <p> 示例值：1
         *
         * @param workMode
         * @return
         */
        public Builder workMode(Integer workMode) {
            this.workMode = workMode;
            return this;
        }

        /**
         * 会话所处的业务模式
         * <p> 示例值：1
         *
         * @param workMode {@link com.lark.oapi.service.vc.v1.enums.MyAiAvPluginScenarioContextWorkModeEnum}
         * @return
         */
        public Builder workMode(com.lark.oapi.service.vc.v1.enums.MyAiAvPluginScenarioContextWorkModeEnum workMode) {
            this.workMode = workMode.getValue();
            return this;
        }


        /**
         * 会话所处的业务场景
         * <p> 示例值：MediaView
         *
         * @param scenario
         * @return
         */
        public Builder scenario(String scenario) {
            this.scenario = scenario;
            return this;
        }

        /**
         * 会话所处的业务场景
         * <p> 示例值：MediaView
         *
         * @param scenario {@link com.lark.oapi.service.vc.v1.enums.MyAiAvPluginScenarioContextScenarioEnum}
         * @return
         */
        public Builder scenario(com.lark.oapi.service.vc.v1.enums.MyAiAvPluginScenarioContextScenarioEnum scenario) {
            this.scenario = scenario.getValue();
            return this;
        }


        /**
         * 会话ID
         * <p> 示例值：ssss
         *
         * @param sessionId
         * @return
         */
        public Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }


        /**
         * upload objects
         * <p> 示例值：
         *
         * @param uploadObjects
         * @return
         */
        public Builder uploadObjects(MyAiAvPluginUploadObject[] uploadObjects) {
            this.uploadObjects = uploadObjects;
            return this;
        }


        /**
         * system info
         * <p> 示例值：
         *
         * @param systemInfo
         * @return
         */
        public Builder systemInfo(MyAiAvPluginContextSystemInfo systemInfo) {
            this.systemInfo = systemInfo;
            return this;
        }


        public MyAiAvPluginScenarioContext build() {
            return new MyAiAvPluginScenarioContext(this);
        }
    }
}
