/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.util;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Snapshot;
import com.weibo.api.motan.closable.Closable;
import com.weibo.api.motan.closable.ShutDownHook;
import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.util.AccessStatisticItem;
import com.weibo.api.motan.util.AccessStatisticResult;
import com.weibo.api.motan.util.InternalMetricsFactory;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.StatisticCallback;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class StatsUtil {
    public static ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);
    protected static ConcurrentMap<String, AccessStatisticItem> accessStatistics = new ConcurrentHashMap<String, AccessStatisticItem>();
    protected static List<StatisticCallback> statisticCallbacks = new CopyOnWriteArrayList<StatisticCallback>();
    public static String SEPARATE = "\\|";
    protected static ScheduledFuture<?> scheduledFuture;
    public static final String HISTOGRAM_NAME;

    public static void registryStatisticCallback(StatisticCallback callback) {
        if (callback == null) {
            LoggerUtil.warn("StatsUtil registryStatisticCallback is null");
            return;
        }
        statisticCallbacks.add(callback);
    }

    public static void unRegistryStatisticCallback(StatisticCallback callback) {
        if (callback == null) {
            LoggerUtil.warn("StatsUtil unRegistryStatisticCallback is null");
            return;
        }
        statisticCallbacks.remove(callback);
    }

    @Deprecated
    public static void accessStatistic(String name, long currentTimeMillis, long costTimeMillis, long bizProcessTime, AccessStatus accessStatus) {
        StatsUtil.accessStatistic(name, URLParamType.application.getValue(), URLParamType.module.getValue(), currentTimeMillis, costTimeMillis, bizProcessTime, accessStatus);
    }

    public static void accessStatistic(String name, String application, String module, long currentTimeMillis, long costTimeMillis, long bizProcessTime, AccessStatus accessStatus) {
        if (name == null || name.isEmpty()) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)application)) {
            application = URLParamType.application.getValue();
        }
        if (StringUtils.isBlank((CharSequence)module)) {
            module = URLParamType.module.getValue();
        }
        name = name + "|" + application + "|" + module;
        try {
            AccessStatisticItem item = StatsUtil.getStatisticItem(name, currentTimeMillis);
            item.statistic(currentTimeMillis, costTimeMillis, bizProcessTime, accessStatus);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static AccessStatisticItem getStatisticItem(String name, long currentTime) {
        AccessStatisticItem item = (AccessStatisticItem)accessStatistics.get(name);
        if (item == null) {
            accessStatistics.putIfAbsent(name, new AccessStatisticItem(name, currentTime));
            item = (AccessStatisticItem)accessStatistics.get(name);
        }
        return item;
    }

    public static ConcurrentMap<String, AccessStatisticResult> getTotalAccessStatistic() {
        return StatsUtil.getTotalAccessStatistic(30);
    }

    public static ConcurrentMap<String, AccessStatisticResult> getTotalAccessStatistic(int peroid) {
        if (peroid > 30) {
            throw new RuntimeException("peroid need <= 30");
        }
        long currentTimeMillis = System.currentTimeMillis();
        ConcurrentHashMap<String, AccessStatisticResult> totalResults = new ConcurrentHashMap<String, AccessStatisticResult>();
        for (Map.Entry entry : accessStatistics.entrySet()) {
            AccessStatisticItem item = (AccessStatisticItem)entry.getValue();
            AccessStatisticResult result = item.getStatisticResult(currentTimeMillis, 30);
            String key = (String)entry.getKey();
            String[] keys = key.split(SEPARATE);
            if (keys.length != 3) continue;
            String application = keys[1];
            String module = keys[2];
            key = application + "|" + module;
            AccessStatisticResult appResult = (AccessStatisticResult)totalResults.get(key);
            if (appResult == null) {
                totalResults.putIfAbsent(key, new AccessStatisticResult());
                appResult = (AccessStatisticResult)totalResults.get(key);
            }
            appResult.totalCount += result.totalCount;
            appResult.bizExceptionCount += result.bizExceptionCount;
            appResult.slowCount += result.slowCount;
            appResult.costTime += result.costTime;
            appResult.bizTime += result.bizTime;
            appResult.otherExceptionCount += result.otherExceptionCount;
        }
        return totalResults;
    }

    public static void logAccessStatistic(boolean clear) {
        DecimalFormat mbFormat = new DecimalFormat("#0.00");
        long currentTimeMillis = System.currentTimeMillis();
        ConcurrentHashMap<String, AccessStatisticResult> totalResults = new ConcurrentHashMap<String, AccessStatisticResult>();
        for (Map.Entry entry : accessStatistics.entrySet()) {
            String key;
            String[] keys;
            AccessStatisticItem item = (AccessStatisticItem)entry.getValue();
            AccessStatisticResult result = item.getStatisticResult(currentTimeMillis, 30);
            if (clear) {
                item.clearStatistic(currentTimeMillis, 30);
            }
            if ((keys = (key = (String)entry.getKey()).split(SEPARATE)).length != 3) continue;
            String application = keys[1];
            String module = keys[2];
            key = application + "|" + module;
            AccessStatisticResult appResult = (AccessStatisticResult)totalResults.get(key);
            if (appResult == null) {
                totalResults.putIfAbsent(key, new AccessStatisticResult());
                appResult = (AccessStatisticResult)totalResults.get(key);
            }
            appResult.totalCount += result.totalCount;
            appResult.bizExceptionCount += result.bizExceptionCount;
            appResult.slowCount += result.slowCount;
            appResult.costTime += result.costTime;
            appResult.bizTime += result.bizTime;
            appResult.otherExceptionCount += result.otherExceptionCount;
            Snapshot snapshot = InternalMetricsFactory.getRegistryInstance((String)entry.getKey()).histogram(HISTOGRAM_NAME).getSnapshot();
            if (application.equals("statisitic")) continue;
            if (result.totalCount == 0) {
                LoggerUtil.accessStatsLog("[motan-accessStatistic] app: " + application + " module: " + module + " item: " + keys[0] + " total_count: 0 slow_count: 0 biz_excp: 0 other_excp: 0 avg_time: 0.00ms biz_time: 0.00ms avg_tps: 0 max_tps: 0 min_tps: 0");
                continue;
            }
            LoggerUtil.accessStatsLog("[motan-accessStatistic] app: {} module: {} item: {} total_count: {} slow_count: {} p75: {} p95: {} p98: {} p99: {} p999: {} biz_excp: {} other_excp: {} avg_time: {}ms biz_time: {}ms avg_tps: {} max_tps: {} min_tps: {} ", application, module, keys[0], result.totalCount, result.slowCount, mbFormat.format(snapshot.get75thPercentile()), mbFormat.format(snapshot.get95thPercentile()), mbFormat.format(snapshot.get98thPercentile()), mbFormat.format(snapshot.get99thPercentile()), mbFormat.format(snapshot.get999thPercentile()), result.bizExceptionCount, result.otherExceptionCount, mbFormat.format(result.costTime / (double)result.totalCount), mbFormat.format(result.bizTime / (double)result.totalCount), result.totalCount / 30, result.maxCount, result.minCount);
        }
        if (!totalResults.isEmpty()) {
            for (Map.Entry entry : totalResults.entrySet()) {
                String application = ((String)entry.getKey()).split(SEPARATE)[0];
                String module = ((String)entry.getKey()).split(SEPARATE)[1];
                AccessStatisticResult totalResult = (AccessStatisticResult)entry.getValue();
                Snapshot snapshot = InternalMetricsFactory.getRegistryInstance((String)entry.getKey()).histogram(HISTOGRAM_NAME).getSnapshot();
                if (totalResult.totalCount > 0) {
                    LoggerUtil.accessStatsLog("[motan-totalAccessStatistic] app: {} module: {} total_count: {} slow_count: {} p75: {} p95: {} p98: {} p99: {} p999: {} biz_excp: {} other_excp: {} avg_time: {}ms biz_time: {}ms avg_tps: {}", application, module, totalResult.totalCount, totalResult.slowCount, mbFormat.format(snapshot.get75thPercentile()), mbFormat.format(snapshot.get95thPercentile()), mbFormat.format(snapshot.get98thPercentile()), mbFormat.format(snapshot.get99thPercentile()), mbFormat.format(snapshot.get999thPercentile()), totalResult.bizExceptionCount, totalResult.otherExceptionCount, mbFormat.format(totalResult.costTime / (double)totalResult.totalCount), mbFormat.format(totalResult.bizTime / (double)totalResult.totalCount), totalResult.totalCount / 30);
                    continue;
                }
                LoggerUtil.accessStatsLog("[motan-totalAccessStatistic] app: " + application + " module: " + module + " total_count: 0 slow_count: 0 biz_excp: 0 other_excp: 0 avg_time: 0.00ms biz_time: 0.00ms avg_tps: 0");
            }
        } else {
            LoggerUtil.accessStatsLog("[motan-totalAccessStatistic] app: " + URLParamType.application.getValue() + " module: " + URLParamType.module.getValue() + " total_count: 0 slow_count: 0 biz_excp: 0 other_excp: 0 avg_time: 0.00ms biz_time: 0.00ms avg_tps: 0");
        }
    }

    public static void logMemoryStatistic() {
        LoggerUtil.accessStatsLog("[motan-memoryStatistic] {} ", StatsUtil.memoryStatistic());
    }

    public static String memoryStatistic() {
        Runtime runtime = Runtime.getRuntime();
        double freeMemory = (double)runtime.freeMemory() / 1048576.0;
        double maxMemory = (double)runtime.maxMemory() / 1048576.0;
        double totalMemory = (double)runtime.totalMemory() / 1048576.0;
        double usedMemory = totalMemory - freeMemory;
        double percentFree = (maxMemory - usedMemory) / maxMemory * 100.0;
        double percentUsed = 100.0 - percentFree;
        DecimalFormat mbFormat = new DecimalFormat("#0.00");
        DecimalFormat percentFormat = new DecimalFormat("#0.0");
        StringBuilder sb = new StringBuilder();
        sb.append(mbFormat.format(usedMemory)).append("MB of ").append(mbFormat.format(maxMemory)).append(" MB (").append(percentFormat.format(percentUsed)).append("%) used");
        return sb.toString();
    }

    public static void logStatisticCallback() {
        for (StatisticCallback callback : statisticCallbacks) {
            try {
                String msg = callback.statisticCallback();
                if (msg == null || msg.isEmpty()) continue;
                LoggerUtil.accessStatsLog("[motan-statisticCallback] {}", msg);
            }
            catch (Exception e) {
                LoggerUtil.error("StatsUtil logStatisticCallback Error: " + e.getMessage(), e);
            }
        }
    }

    static {
        HISTOGRAM_NAME = MetricRegistry.name(AccessStatisticItem.class, (String[])new String[]{"costTimeMillis"});
        scheduledFuture = executorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                StatsUtil.logAccessStatistic(true);
                StatsUtil.logMemoryStatistic();
                StatsUtil.logStatisticCallback();
            }
        }, 30L, 30L, TimeUnit.SECONDS);
        ShutDownHook.registerShutdownHook(new Closable(){

            @Override
            public void close() {
                if (!executorService.isShutdown()) {
                    executorService.shutdown();
                }
            }
        });
    }

    public static enum AccessStatus {
        NORMAL,
        BIZ_EXCEPTION,
        OTHER_EXCEPTION;

    }
}

