/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.util;

import com.weibo.api.motan.common.MotanConstants;
import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.StringTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UrlUtils {
    public static List<URL> parseURLs(String address, Map<String, String> defaults) {
        if (address == null || address.length() == 0) {
            return null;
        }
        String[] addresses = MotanConstants.REGISTRY_SPLIT_PATTERN.split(address);
        if (addresses == null || addresses.length == 0) {
            return null;
        }
        ArrayList<URL> registries = new ArrayList<URL>();
        for (String addr : addresses) {
            registries.add(UrlUtils.parseURL(addr, defaults));
        }
        return registries;
    }

    public static Map<String, String> parseQueryParams(String rawRefer) {
        String[] kvs;
        HashMap<String, String> map = new HashMap<String, String>();
        String refer = StringTools.urlDecode(rawRefer);
        for (String kv : kvs = MotanConstants.QUERY_PARAM_PATTERN.split(refer)) {
            String[] kvArr;
            if (kv == null || !kv.contains("=") || (kvArr = MotanConstants.EQUAL_SIGN_PATTERN.split(kv)).length != 2) continue;
            map.put(kvArr[0].trim(), kvArr[1].trim());
        }
        return map;
    }

    private static URL parseURL(String address, Map<String, String> defaults) {
        HashMap<String, String> defaultParameters;
        String defaultProtocol;
        if (address == null || address.length() == 0) {
            return null;
        }
        String[] addresses = MotanConstants.COMMA_SPLIT_PATTERN.split(address);
        String url = addresses[0];
        String string = defaultProtocol = defaults == null ? null : defaults.get("protocol");
        if (defaultProtocol == null || defaultProtocol.length() == 0) {
            defaultProtocol = URLParamType.protocol.getValue();
        }
        int defaultPort = StringTools.parseInteger(defaults == null ? null : defaults.get("port"));
        String defaultPath = defaults == null ? null : defaults.get("path");
        HashMap<String, String> hashMap = defaultParameters = defaults == null ? null : new HashMap<String, String>(defaults);
        if (defaultParameters != null) {
            defaultParameters.remove("protocol");
            defaultParameters.remove("host");
            defaultParameters.remove("port");
            defaultParameters.remove("path");
        }
        URL u = URL.valueOf(url);
        u.addParameters(defaults);
        boolean changed = false;
        String protocol = u.getProtocol();
        String host = u.getHost();
        int port = u.getPort();
        String path = u.getPath();
        HashMap<String, String> parameters = new HashMap<String, String>(u.getParameters());
        if ((protocol == null || protocol.length() == 0) && defaultProtocol != null && defaultProtocol.length() > 0) {
            changed = true;
            protocol = defaultProtocol;
        }
        if (port <= 0) {
            if (defaultPort > 0) {
                changed = true;
                port = defaultPort;
            } else {
                changed = true;
                port = 0;
            }
        }
        if ((path == null || path.length() == 0) && defaultPath != null && defaultPath.length() > 0) {
            changed = true;
            path = defaultPath;
        }
        if (defaultParameters != null && defaultParameters.size() > 0) {
            for (Map.Entry entry : defaultParameters.entrySet()) {
                String value;
                String key = (String)entry.getKey();
                String defaultValue = (String)entry.getValue();
                if (defaultValue == null || defaultValue.length() <= 0 || (value = (String)parameters.get(key)) != null && value.length() != 0) continue;
                changed = true;
                parameters.put(key, defaultValue);
            }
        }
        if (changed) {
            u = new URL(protocol, host, port, path, parameters);
        }
        return u;
    }
}

