/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.registry.client.util.json;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicJsonwriter {
    private static Logger logger = LoggerFactory.getLogger(BasicJsonwriter.class);
    private static final String STR_SLASH = "\"";
    private static final String STR_SLASH_STR = "\":";
    private static final String STR_COMMA = ",";
    private static final String STR_OBJECT_LEFT = "{";
    private static final String STR_OBJECT_RIGHT = "}";
    private static final String STR_ARRAY_LEFT = "[";
    private static final String STR_ARRAY_RIGHT = "]";
    private static final Map<String, Field[]> cacheFields = new HashMap<String, Field[]>();

    public String toJson(Object object) {
        StringBuilder json = new StringBuilder();
        try {
            this.writeObjItem(null, object, json);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        String str = json.toString();
        if (str.contains("\n")) {
            str = str.replaceAll("\\n", "\\\\n");
        }
        if (str.contains("\t")) {
            str = str.replaceAll("\\t", "\\\\t");
        }
        if (str.contains("\r")) {
            str = str.replaceAll("\\r", "\\\\r");
        }
        return str;
    }

    private void writeObjItem(String key, Object value, StringBuilder json) {
        if (key != null) {
            json.append(STR_SLASH).append(key).append(STR_SLASH_STR);
        }
        if (value == null) {
            json.append("null");
        } else if (value instanceof String || value instanceof Byte || value instanceof CharSequence) {
            json.append(STR_SLASH).append(value.toString()).append(STR_SLASH);
        } else if (value instanceof Boolean || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double) {
            json.append(value);
        } else if (value instanceof Object[] || value instanceof Collection) {
            List<Object> valueColl = null;
            if (value instanceof Object[]) {
                Object[] valueArr = (Object[])value;
                valueColl = Arrays.asList(valueArr);
            } else if (value instanceof Collection) {
                valueColl = (List<Object>)value;
            }
            json.append(STR_ARRAY_LEFT);
            if (valueColl.size() > 0) {
                for (Object e : valueColl) {
                    this.writeObjItem(null, e, json);
                    json.append(STR_COMMA);
                }
                json.delete(json.length() - 1, json.length());
            }
            json.append(STR_ARRAY_RIGHT);
        } else if (value instanceof Map) {
            Map valueMap = (Map)value;
            json.append(STR_OBJECT_LEFT);
            if (!valueMap.isEmpty()) {
                Set keys = valueMap.keySet();
                for (Object valueMapItemKey : keys) {
                    this.writeObjItem(valueMapItemKey.toString(), valueMap.get(valueMapItemKey), json);
                    json.append(STR_COMMA);
                }
                json.delete(json.length() - 1, json.length());
            }
            json.append(STR_OBJECT_RIGHT);
        } else {
            json.append(STR_OBJECT_LEFT);
            Field[] fields = this.getDeclaredFields(value.getClass());
            if (fields.length > 0) {
                for (Field field : fields) {
                    Object fieldObj = this.getFieldObject(field, value);
                    this.writeObjItem(field.getName(), fieldObj, json);
                    json.append(STR_COMMA);
                }
                json.delete(json.length() - 1, json.length());
            }
            json.append(STR_OBJECT_RIGHT);
        }
    }

    public synchronized Field[] getDeclaredFields(Class<?> clazz) {
        String cacheKey = clazz.getName();
        if (cacheFields.containsKey(cacheKey)) {
            return cacheFields.get(cacheKey);
        }
        Field[] fields = this.getAllDeclaredFields(clazz);
        cacheFields.put(cacheKey, fields);
        return fields;
    }

    private Field[] getAllDeclaredFields(Class<?> clazz) {
        ArrayList<Field> list = new ArrayList<Field>();
        for (Class<?> current = clazz; current != null && current != Object.class; current = current.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = current.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                list.add(field);
            }
        }
        return list.toArray(new Field[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Object getFieldObject(Field field, Object obj) {
        try {
            field.setAccessible(true);
            Object object = field.get(obj);
            return object;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            logger.error(e.getMessage(), (Throwable)e);
            Object var4_5 = null;
            return var4_5;
        }
        finally {
            field.setAccessible(false);
        }
    }
}

