/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.notify.filter.web;

import de.codecentric.boot.admin.notify.filter.ApplicationIdNotificationFilter;
import de.codecentric.boot.admin.notify.filter.ApplicationNameNotificationFilter;
import de.codecentric.boot.admin.notify.filter.ExpiringNotificationFilter;
import de.codecentric.boot.admin.notify.filter.FilteringNotifier;
import de.codecentric.boot.admin.notify.filter.NotificationFilter;
import de.codecentric.boot.admin.web.AdminController;
import java.util.Collections;
import java.util.Map;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@AdminController
@ResponseBody
@RequestMapping(value={"/api/notifications/filters"})
public class NotificationFilterController {
    private FilteringNotifier filteringNotifier;

    public NotificationFilterController(FilteringNotifier filteringNotifier) {
        this.filteringNotifier = filteringNotifier;
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    public Map<String, NotificationFilter> getFilters() {
        return this.filteringNotifier.getNotificationFilters();
    }

    @RequestMapping(method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<?> addFilter(@RequestParam(name="id", required=false) String id, @RequestParam(name="name", required=false) String name, @RequestParam(name="ttl", required=false, defaultValue="-1") long ttl) {
        if (StringUtils.hasText((String)id) || StringUtils.hasText((String)name)) {
            NotificationFilter filter = this.createFilter(id, name, ttl);
            String filterId = this.filteringNotifier.addFilter(filter);
            return ResponseEntity.ok(Collections.singletonMap(filterId, filter));
        }
        return ResponseEntity.badRequest().body((Object)"Either 'id' or 'name' must be set");
    }

    @RequestMapping(path={"/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<?> deleteFilter(@PathVariable(value="id") String id) {
        NotificationFilter deleted = this.filteringNotifier.removeFilter(id);
        if (deleted != null) {
            return ResponseEntity.ok((Object)deleted);
        }
        return ResponseEntity.notFound().build();
    }

    private NotificationFilter createFilter(String id, String name, long ttl) {
        long expiry = ttl > 0L ? System.currentTimeMillis() + ttl : ttl;
        ExpiringNotificationFilter filter = StringUtils.hasText((String)id) ? new ApplicationIdNotificationFilter(id, expiry) : new ApplicationNameNotificationFilter(name, expiry);
        return filter;
    }
}

