/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.maven.plugin.mojo;

import icu.easyj.maven.plugin.mojo.utils.IOUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractEasyjMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.basedir}")
    protected File outputDirectory;

    protected String replacePlaceholder(String str) {
        return str.replaceAll("\\{\\s*(groupId)\\s*\\}", this.project.getGroupId()).replaceAll("\\{\\s*(artifactId)\\s*\\}", this.project.getArtifactId()).replaceAll("\\{\\s*(version)\\s*\\}", this.project.getVersion()).replaceAll("\\{\\s*(finalName)\\s*\\}", this.project.getBuild().getFinalName());
    }

    protected boolean isRuntimeArtifact(Artifact artifact) {
        if (artifact.isOptional()) {
            return false;
        }
        String scope = artifact.getScope();
        return scope == null || scope.trim().isEmpty() || "compile".equalsIgnoreCase(scope) || "runtime".equalsIgnoreCase(scope);
    }

    protected Properties getOriginalProperties() {
        return this.project.getOriginalModel().getProperties();
    }

    protected String getProperty(String key) {
        return this.project.getProperties().getProperty(key);
    }

    protected void putProperty(Properties properties, String key, Object value, String info) {
        properties.put(key, value);
        this.info("Put property '%s' = '%s' %s.", key, value == null ? "null" : value.toString(), info == null ? "" : info);
    }

    protected void putProperty(Properties properties, String key, Object value) {
        this.putProperty(properties, key, value, null);
    }

    protected void putProperty(String key, Object value, String info) {
        this.putProperty(this.project.getProperties(), key, value, info);
    }

    protected void putProperty(String key, Object value) {
        this.putProperty(key, value, null);
    }

    protected boolean containsProperty(String key) {
        return this.project.getProperties().containsKey(key);
    }

    protected boolean containsProperty(String key, String targetValue) {
        String value = this.project.getProperties().getProperty(key);
        return targetValue.equalsIgnoreCase(value);
    }

    protected boolean containsProperty(String key, String targetValue, boolean ignoreCase) {
        String value = this.project.getProperties().getProperty(key);
        if (value == null) {
            return false;
        }
        return ignoreCase ? targetValue.equalsIgnoreCase(value) : targetValue.equals(value);
    }

    protected File getTargetDir() {
        return new File(this.outputDirectory, "target\\");
    }

    protected File createTargetDir() {
        File targetDir = this.getTargetDir();
        if (!targetDir.exists() && !targetDir.mkdirs()) {
            throw new RuntimeException("Failed to create '" + targetDir.getPath() + "' directory.");
        }
        return targetDir;
    }

    protected File createLibDir() {
        return this.createLibDir("lib");
    }

    protected File createLibDir(String libDirName) {
        File libDir = new File(this.outputDirectory, "target\\" + libDirName);
        if (!libDir.exists() && !libDir.mkdirs()) {
            throw new RuntimeException("Failed to create '" + libDir.getPath() + "' directory.");
        }
        return libDir;
    }

    protected void emptyLine() {
        this.getLog().info((CharSequence)"");
    }

    protected void debug(String content) {
        this.getLog().debug((CharSequence)content);
    }

    protected void debug(String content, Throwable cause) {
        this.getLog().debug((CharSequence)content, cause);
    }

    protected void debug(String format, Object ... args) {
        Object[] newArgs = this.handleArgs(args);
        if (newArgs == args) {
            this.getLog().debug((CharSequence)String.format(format, args));
        } else {
            this.getLog().debug((CharSequence)String.format(format, args), (Throwable)args[args.length - 1]);
        }
    }

    protected void info(String content) {
        this.getLog().info((CharSequence)content);
    }

    protected void info(String content, Throwable cause) {
        this.getLog().info((CharSequence)content, cause);
    }

    protected void info(String format, Object ... args) {
        Object[] newArgs = this.handleArgs(args);
        if (newArgs == args) {
            this.getLog().info((CharSequence)String.format(format, args));
        } else {
            this.getLog().info((CharSequence)String.format(format, args), (Throwable)args[args.length - 1]);
        }
    }

    protected void warn(String content) {
        this.getLog().warn((CharSequence)content);
    }

    protected void warn(String content, Throwable cause) {
        this.getLog().warn((CharSequence)content, cause);
    }

    protected void warn(String format, Object ... args) {
        Object[] newArgs = this.handleArgs(args);
        if (newArgs == args) {
            this.getLog().warn((CharSequence)String.format(format, args));
        } else {
            this.getLog().warn((CharSequence)String.format(format, args), (Throwable)args[args.length - 1]);
        }
    }

    protected void error(String content) {
        this.getLog().error((CharSequence)content);
    }

    protected void error(String content, Throwable cause) {
        this.getLog().error((CharSequence)content, cause);
    }

    protected void error(String format, Object ... args) {
        Object[] newArgs = this.handleArgs(args);
        if (newArgs == args) {
            this.getLog().error((CharSequence)String.format(format, args));
        } else {
            this.getLog().error((CharSequence)String.format(format, args), (Throwable)args[args.length - 1]);
        }
    }

    private Object[] handleArgs(Object ... args) {
        if (args == null || args.length == 0) {
            return args;
        }
        if (args[args.length - 1] instanceof Throwable) {
            return Arrays.copyOf(args, args.length - 1);
        }
        return args;
    }

    protected String collectionToStr(Collection coll) {
        if (coll == null) {
            return "null";
        }
        if (coll.isEmpty()) {
            return "<empty>";
        }
        String collStr = coll.toString();
        return this.handleListStr(collStr.substring(1, collStr.length() - 1));
    }

    protected String handleListStr(String arrStr) {
        return arrStr.replaceAll("^|\\s*,\\s*", "\r\n         - ");
    }

    protected void copyFile(File sourceFile, File targetFile) {
        try {
            IOUtils.copy(sourceFile, targetFile);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Copy file failed: %s -> %s", sourceFile.getPath(), targetFile.getPath()));
        }
    }

    protected void copyFileToDir(File sourceFile, File targetDir, boolean needLog) {
        this.copyFile(sourceFile, new File(targetDir, sourceFile.getName()));
        if (needLog) {
            this.info("Copy file '%s' to the directory '%s'.", sourceFile.getName(), targetDir.getPath());
        }
    }

    protected void copyFileToDir(File sourceFile, File targetDir) {
        this.copyFileToDir(sourceFile, targetDir, false);
    }

    protected void copyFilesToDir(Collection<File> sourceFiles, File targetDir, boolean needLog) {
        for (File sourceFile : sourceFiles) {
            this.copyFileToDir(sourceFile, targetDir, needLog);
        }
    }

    protected void copyFilesToDir(Collection<File> sourceFiles, File targetDir) {
        this.copyFilesToDir(sourceFiles, targetDir, false);
    }
}

