/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.maven.plugin.mojo.springboot;

import icu.easyj.maven.plugin.mojo.springboot.AbstractSpringBootMojo;
import icu.easyj.maven.plugin.mojo.utils.MatchUtils;
import icu.easyj.maven.plugin.mojo.utils.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="spring-boot-release", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class SpringBootReleaseMojo
extends AbstractSpringBootMojo {
    @Parameter(property="maven.spring-boot-release.filePatterns", defaultValue="{finalName}.jar,lib-*.zip,startup.*")
    private Set<String> filePatterns;
    @Parameter(property="maven.spring-boot-release.dir")
    private String releaseDirectory;

    @Override
    public void doExecute() throws MojoExecutionException {
        if (StringUtils.isEmpty(this.releaseDirectory)) {
            throw new RuntimeException("'releaseDirectory' must be not empty.");
        }
        File releaseDir = this.createReleaseDir();
        File targetDir = this.getTargetDir();
        if (!targetDir.exists()) {
            throw new RuntimeException("The '/target/' directory is not exists.");
        }
        Set<String> patterns = this.handleFilePatterns();
        this.info("The file patterns: " + patterns);
        File[] files = targetDir.listFiles();
        if (files != null) {
            ArrayList<File> fileList = new ArrayList<File>(files.length);
            for (File file : files) {
                if (!file.isFile() || !MatchUtils.match(patterns, file.getName())) continue;
                fileList.add(file);
            }
            this.copyFilesToDir(fileList, releaseDir, true);
        }
    }

    private File createReleaseDir() {
        String releaseDirectory = this.replacePlaceholder(this.releaseDirectory.trim()).replaceAll("[\\*\\?\\\"'\\<\\>\\|]+", "");
        this.info("The release directory: " + releaseDirectory);
        File releaseDir = new File(releaseDirectory);
        if (!releaseDir.exists() && !releaseDir.mkdirs()) {
            throw new RuntimeException("Create release directory failed\uff1a" + releaseDir.getPath());
        }
        return releaseDir;
    }

    private Set<String> handleFilePatterns() {
        HashSet<String> patterns = new HashSet<String>();
        for (String filePattern : this.filePatterns) {
            if (StringUtils.isEmpty(filePattern)) continue;
            patterns.add(this.replacePlaceholder(filePattern.trim()));
        }
        return patterns;
    }
}

