/*
 * Decompiled with CFR 0.152.
 */
package com.livk.autoconfigure.curator;

import com.livk.autoconfigure.curator.CuratorFactory;
import com.livk.autoconfigure.curator.CuratorFrameworkBuilderCustomizer;
import com.livk.autoconfigure.curator.CuratorProperties;
import com.livk.context.curator.CuratorTemplate;
import org.apache.curator.RetryPolicy;
import org.apache.curator.drivers.TracerDriver;
import org.apache.curator.ensemble.EnsembleProvider;
import org.apache.curator.framework.CuratorFramework;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={CuratorFramework.class})
@EnableConfigurationProperties(value={CuratorProperties.class})
@ConditionalOnProperty(value={"spring.zookeeper.curator.enabled"}, matchIfMissing=true)
public class CuratorAutoConfiguration {
    @Bean(destroyMethod="close")
    @ConditionalOnMissingBean
    public CuratorFramework curatorFramework(CuratorProperties properties, RetryPolicy retryPolicy, ObjectProvider<CuratorFrameworkBuilderCustomizer> curatorFrameworkBuilderCustomizers, ObjectProvider<EnsembleProvider> ensembleProviders, ObjectProvider<TracerDriver> tracerDrivers) throws InterruptedException {
        return CuratorFactory.curatorFramework(properties, retryPolicy, () -> curatorFrameworkBuilderCustomizers.orderedStream(), () -> ensembleProviders.getIfAvailable(), () -> tracerDrivers.getIfAvailable());
    }

    @Bean
    @ConditionalOnMissingBean
    public RetryPolicy exponentialBackoffRetry(CuratorProperties properties) {
        return CuratorFactory.retryPolicy(properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public CuratorTemplate curatorTemplate(CuratorFramework curatorFramework) {
        return new CuratorTemplate(curatorFramework);
    }
}

