/*
 * Decompiled with CFR 0.152.
 */
package com.livk.autoconfigure.curator;

import com.livk.autoconfigure.curator.CuratorFrameworkBuilderCustomizer;
import com.livk.autoconfigure.curator.CuratorProperties;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.curator.RetryPolicy;
import org.apache.curator.drivers.TracerDriver;
import org.apache.curator.ensemble.EnsembleProvider;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CuratorFactory {
    private static final Logger log = LoggerFactory.getLogger(CuratorFactory.class);

    public static CuratorFramework curatorFramework(CuratorProperties properties, RetryPolicy retryPolicy, Supplier<Stream<CuratorFrameworkBuilderCustomizer>> optionalCuratorFrameworkCustomizerProvider, Supplier<EnsembleProvider> optionalEnsembleProvider, Supplier<TracerDriver> optionalTracerDriverProvider) throws InterruptedException {
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder();
        EnsembleProvider ensembleProvider = optionalEnsembleProvider.get();
        if (ensembleProvider != null) {
            builder.ensembleProvider(ensembleProvider);
        } else {
            builder.connectString(properties.getConnectString());
        }
        builder.sessionTimeoutMs((int)properties.getSessionTimeout().toMillis()).connectionTimeoutMs((int)properties.getConnectionTimeout().toMillis()).retryPolicy(retryPolicy);
        Stream<CuratorFrameworkBuilderCustomizer> customizers = optionalCuratorFrameworkCustomizerProvider.get();
        if (customizers != null) {
            customizers.forEach(curatorFrameworkCustomizer -> curatorFrameworkCustomizer.customize(builder));
        }
        CuratorFramework curator = builder.build();
        TracerDriver tracerDriver = optionalTracerDriverProvider.get();
        if (tracerDriver != null && curator.getZookeeperClient() != null) {
            curator.getZookeeperClient().setTracerDriver(tracerDriver);
        }
        curator.start();
        if (log.isTraceEnabled()) {
            log.trace("blocking until connected to zookeeper for " + properties.getBlockUntilConnectedWait() + String.valueOf((Object)properties.getBlockUntilConnectedUnit()));
        }
        curator.blockUntilConnected(properties.getBlockUntilConnectedWait().intValue(), properties.getBlockUntilConnectedUnit());
        if (log.isTraceEnabled()) {
            log.trace("connected to zookeeper");
        }
        return curator;
    }

    public static RetryPolicy retryPolicy(CuratorProperties properties) {
        return new ExponentialBackoffRetry(properties.getBaseSleepTimeMs().intValue(), properties.getMaxRetries().intValue(), properties.getMaxSleepMs().intValue());
    }
}

