/*
 * Decompiled with CFR 0.152.
 */
package com.livk.autoconfigure.curator;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;

@ConfigurationProperties(value="spring.zookeeper.curator")
public class CuratorProperties {
    public static final String PREFIX = "spring.zookeeper.curator";
    private String connectString = "localhost:2181";
    private boolean enabled = true;
    private Integer baseSleepTimeMs = 50;
    private Integer maxRetries = 10;
    private Integer maxSleepMs = 500;
    private Integer blockUntilConnectedWait = 10;
    private TimeUnit blockUntilConnectedUnit = TimeUnit.SECONDS;
    @DurationUnit(value=ChronoUnit.MILLIS)
    private Duration sessionTimeout = Duration.of(60000L, ChronoUnit.MILLIS);
    @DurationUnit(value=ChronoUnit.MILLIS)
    private Duration connectionTimeout = Duration.of(15000L, ChronoUnit.MILLIS);

    public String getConnectString() {
        return this.connectString;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Integer getBaseSleepTimeMs() {
        return this.baseSleepTimeMs;
    }

    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    public Integer getMaxSleepMs() {
        return this.maxSleepMs;
    }

    public Integer getBlockUntilConnectedWait() {
        return this.blockUntilConnectedWait;
    }

    public TimeUnit getBlockUntilConnectedUnit() {
        return this.blockUntilConnectedUnit;
    }

    public Duration getSessionTimeout() {
        return this.sessionTimeout;
    }

    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectString(String connectString) {
        this.connectString = connectString;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setBaseSleepTimeMs(Integer baseSleepTimeMs) {
        this.baseSleepTimeMs = baseSleepTimeMs;
    }

    public void setMaxRetries(Integer maxRetries) {
        this.maxRetries = maxRetries;
    }

    public void setMaxSleepMs(Integer maxSleepMs) {
        this.maxSleepMs = maxSleepMs;
    }

    public void setBlockUntilConnectedWait(Integer blockUntilConnectedWait) {
        this.blockUntilConnectedWait = blockUntilConnectedWait;
    }

    public void setBlockUntilConnectedUnit(TimeUnit blockUntilConnectedUnit) {
        this.blockUntilConnectedUnit = blockUntilConnectedUnit;
    }

    public void setSessionTimeout(Duration sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public void setConnectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CuratorProperties)) {
            return false;
        }
        CuratorProperties other = (CuratorProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        Integer this$baseSleepTimeMs = this.getBaseSleepTimeMs();
        Integer other$baseSleepTimeMs = other.getBaseSleepTimeMs();
        if (this$baseSleepTimeMs == null ? other$baseSleepTimeMs != null : !((Object)this$baseSleepTimeMs).equals(other$baseSleepTimeMs)) {
            return false;
        }
        Integer this$maxRetries = this.getMaxRetries();
        Integer other$maxRetries = other.getMaxRetries();
        if (this$maxRetries == null ? other$maxRetries != null : !((Object)this$maxRetries).equals(other$maxRetries)) {
            return false;
        }
        Integer this$maxSleepMs = this.getMaxSleepMs();
        Integer other$maxSleepMs = other.getMaxSleepMs();
        if (this$maxSleepMs == null ? other$maxSleepMs != null : !((Object)this$maxSleepMs).equals(other$maxSleepMs)) {
            return false;
        }
        Integer this$blockUntilConnectedWait = this.getBlockUntilConnectedWait();
        Integer other$blockUntilConnectedWait = other.getBlockUntilConnectedWait();
        if (this$blockUntilConnectedWait == null ? other$blockUntilConnectedWait != null : !((Object)this$blockUntilConnectedWait).equals(other$blockUntilConnectedWait)) {
            return false;
        }
        String this$connectString = this.getConnectString();
        String other$connectString = other.getConnectString();
        if (this$connectString == null ? other$connectString != null : !this$connectString.equals(other$connectString)) {
            return false;
        }
        TimeUnit this$blockUntilConnectedUnit = this.getBlockUntilConnectedUnit();
        TimeUnit other$blockUntilConnectedUnit = other.getBlockUntilConnectedUnit();
        if (this$blockUntilConnectedUnit == null ? other$blockUntilConnectedUnit != null : !((Object)((Object)this$blockUntilConnectedUnit)).equals((Object)other$blockUntilConnectedUnit)) {
            return false;
        }
        Duration this$sessionTimeout = this.getSessionTimeout();
        Duration other$sessionTimeout = other.getSessionTimeout();
        if (this$sessionTimeout == null ? other$sessionTimeout != null : !((Object)this$sessionTimeout).equals(other$sessionTimeout)) {
            return false;
        }
        Duration this$connectionTimeout = this.getConnectionTimeout();
        Duration other$connectionTimeout = other.getConnectionTimeout();
        return !(this$connectionTimeout == null ? other$connectionTimeout != null : !((Object)this$connectionTimeout).equals(other$connectionTimeout));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CuratorProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        Integer $baseSleepTimeMs = this.getBaseSleepTimeMs();
        result = result * 59 + ($baseSleepTimeMs == null ? 43 : ((Object)$baseSleepTimeMs).hashCode());
        Integer $maxRetries = this.getMaxRetries();
        result = result * 59 + ($maxRetries == null ? 43 : ((Object)$maxRetries).hashCode());
        Integer $maxSleepMs = this.getMaxSleepMs();
        result = result * 59 + ($maxSleepMs == null ? 43 : ((Object)$maxSleepMs).hashCode());
        Integer $blockUntilConnectedWait = this.getBlockUntilConnectedWait();
        result = result * 59 + ($blockUntilConnectedWait == null ? 43 : ((Object)$blockUntilConnectedWait).hashCode());
        String $connectString = this.getConnectString();
        result = result * 59 + ($connectString == null ? 43 : $connectString.hashCode());
        TimeUnit $blockUntilConnectedUnit = this.getBlockUntilConnectedUnit();
        result = result * 59 + ($blockUntilConnectedUnit == null ? 43 : ((Object)((Object)$blockUntilConnectedUnit)).hashCode());
        Duration $sessionTimeout = this.getSessionTimeout();
        result = result * 59 + ($sessionTimeout == null ? 43 : ((Object)$sessionTimeout).hashCode());
        Duration $connectionTimeout = this.getConnectionTimeout();
        result = result * 59 + ($connectionTimeout == null ? 43 : ((Object)$connectionTimeout).hashCode());
        return result;
    }

    public String toString() {
        return "CuratorProperties(connectString=" + this.getConnectString() + ", enabled=" + this.isEnabled() + ", baseSleepTimeMs=" + this.getBaseSleepTimeMs() + ", maxRetries=" + this.getMaxRetries() + ", maxSleepMs=" + this.getMaxSleepMs() + ", blockUntilConnectedWait=" + this.getBlockUntilConnectedWait() + ", blockUntilConnectedUnit=" + String.valueOf((Object)this.getBlockUntilConnectedUnit()) + ", sessionTimeout=" + String.valueOf(this.getSessionTimeout()) + ", connectionTimeout=" + String.valueOf(this.getConnectionTimeout()) + ")";
    }
}

