/*
 * Decompiled with CFR 0.152.
 */
package com.livk.autoconfigure.dynamic;

import com.livk.autoconfigure.dynamic.DynamicDatasourceProperties;
import com.livk.context.dynamic.DynamicDatasource;
import com.livk.context.dynamic.intercept.DataSourceInterceptor;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(before={DataSourceAutoConfiguration.class})
@EnableConfigurationProperties(value={DynamicDatasourceProperties.class})
public class DynamicAutoConfiguration {
    @Bean
    public DynamicDatasource dynamicDatasource(DynamicDatasourceProperties datasourceProperties) {
        Map<Object, Object> datasourceMap = datasourceProperties.getDatasource().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((DataSourceProperties)entry.getValue()).initializeDataSourceBuilder().build()));
        DynamicDatasource dynamicDatasource = new DynamicDatasource();
        dynamicDatasource.setTargetDataSources(datasourceMap);
        dynamicDatasource.setDefaultTargetDataSource(datasourceMap.get(datasourceProperties.getPrimary()));
        return dynamicDatasource;
    }

    @Bean
    public DataSourceInterceptor dataSourceInterceptor() {
        return new DataSourceInterceptor();
    }
}

