/*
 * Decompiled with CFR 0.152.
 */
package com.livk.autoconfigure.dynamic;

import com.livk.autoconfigure.dynamic.exception.PrimaryNotFountException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="spring.dynamic")
public class DynamicDatasourceProperties
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(DynamicDatasourceProperties.class);
    public static final String PREFIX = "spring.dynamic";
    private Map<String, DataSourceProperties> datasource;
    private String primary;

    public void afterPropertiesSet() {
        if (StringUtils.hasText((String)this.primary)) {
            if (!this.datasource.containsKey(this.primary)) {
                throw new PrimaryNotFountException(this.primary + "\u6570\u636e\u6e90\u4e0d\u5b58\u5728!\n\u5f53\u524d\u6570\u636e\u6e90:" + String.valueOf(this.datasource.keySet()));
            }
        } else {
            throw new PrimaryNotFountException("\u7f3a\u5c11primary\u6570\u636e\u6e90!");
        }
        log.info("\u5f53\u524d\u4e3b\u6570\u636e\u6e90:" + this.primary);
    }

    public Map<String, DataSourceProperties> getDatasource() {
        return this.datasource;
    }

    public String getPrimary() {
        return this.primary;
    }

    public void setDatasource(Map<String, DataSourceProperties> datasource) {
        this.datasource = datasource;
    }

    public void setPrimary(String primary) {
        this.primary = primary;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamicDatasourceProperties)) {
            return false;
        }
        DynamicDatasourceProperties other = (DynamicDatasourceProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, DataSourceProperties> this$datasource = this.getDatasource();
        Map<String, DataSourceProperties> other$datasource = other.getDatasource();
        if (this$datasource == null ? other$datasource != null : !((Object)this$datasource).equals(other$datasource)) {
            return false;
        }
        String this$primary = this.getPrimary();
        String other$primary = other.getPrimary();
        return !(this$primary == null ? other$primary != null : !this$primary.equals(other$primary));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DynamicDatasourceProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, DataSourceProperties> $datasource = this.getDatasource();
        result = result * 59 + ($datasource == null ? 43 : ((Object)$datasource).hashCode());
        String $primary = this.getPrimary();
        result = result * 59 + ($primary == null ? 43 : $primary.hashCode());
        return result;
    }

    public String toString() {
        return "DynamicDatasourceProperties(datasource=" + String.valueOf(this.getDatasource()) + ", primary=" + this.getPrimary() + ")";
    }
}

