/*
 * Decompiled with CFR 0.152.
 */
package com.livk.autoconfigure.http;

import com.livk.autoconfigure.http.annotation.HttpProvider;
import com.livk.autoconfigure.http.factory.AdapterFactory;
import com.livk.autoconfigure.http.factory.AdapterType;
import com.livk.autoconfigure.http.factory.HttpFactoryBean;
import com.livk.commons.util.AnnotationUtils;
import com.livk.commons.util.ClassUtils;
import java.lang.annotation.Annotation;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.annotation.AnnotationBeanNameGenerator;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.web.service.invoker.HttpExchangeAdapter;

public class ClassPathHttpScanner
extends ClassPathBeanDefinitionScanner {
    private final BeanNameGenerator beanNameGenerator = new AnnotationBeanNameGenerator();

    public ClassPathHttpScanner(BeanDefinitionRegistry registry, Environment environment) {
        super(registry, false, environment);
    }

    public void registerFilters(Class<? extends Annotation> annotationType) {
        this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(annotationType));
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        return beanDefinition.getMetadata().isIndependent() && !beanDefinition.getMetadata().isAnnotation();
    }

    @NonNull
    protected Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        BeanDefinitionRegistry registry = super.getRegistry();
        Assert.notNull((Object)registry, (String)"registry not be null");
        Assert.notEmpty((Object[])basePackages, (String)"At least one base package must be specified");
        LinkedHashSet<BeanDefinitionHolder> beanDefinitions = new LinkedHashSet<BeanDefinitionHolder>();
        for (String basePackage : basePackages) {
            Set candidateComponents = this.findCandidateComponents(basePackage);
            for (BeanDefinition candidateComponent : candidateComponents) {
                if (!(candidateComponent instanceof ScannedGenericBeanDefinition)) continue;
                ScannedGenericBeanDefinition scannedGenericBeanDefinition = (ScannedGenericBeanDefinition)candidateComponent;
                AnnotationAttributes attributes = AnnotationUtils.attributesFor((AnnotatedTypeMetadata)scannedGenericBeanDefinition.getMetadata(), HttpProvider.class);
                AdapterType type = (AdapterType)attributes.getEnum("type");
                AdapterFactory<? extends HttpExchangeAdapter> adapterFactory = AdapterType.builder(type);
                String beanClassName = candidateComponent.getBeanClassName();
                Assert.notNull((Object)beanClassName, (String)"beanClassName not be null");
                Class beanType = ClassUtils.resolveClassName((String)beanClassName, (ClassLoader)super.getResourceLoader().getClassLoader());
                BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(HttpFactoryBean.class);
                builder.addPropertyValue("type", (Object)beanType);
                builder.addPropertyValue("adapterFactory", adapterFactory);
                builder.setAutowireMode(2);
                AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
                String beanName = this.beanNameGenerator.generateBeanName(candidateComponent, registry);
                if (!this.checkCandidate(beanName, (BeanDefinition)beanDefinition)) continue;
                beanDefinition.setAttribute("factoryBeanObjectType", (Object)beanType);
                BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)beanDefinition, beanName);
                beanDefinitions.add(holder);
                this.registerBeanDefinition(holder, registry);
            }
        }
        return beanDefinitions;
    }
}

