/*
 * Decompiled with CFR 0.152.
 */
package com.livk.autoconfigure.http.factory;

import com.livk.autoconfigure.http.factory.AdapterFactory;
import com.livk.commons.util.ClassUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.client.support.RestClientAdapter;
import org.springframework.web.client.support.RestTemplateAdapter;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.support.WebClientAdapter;
import org.springframework.web.service.invoker.HttpExchangeAdapter;

public enum AdapterType {
    REST_TEMPLATE,
    WEB_CLIENT,
    REST_CLIENT,
    AUTO;


    public static AdapterFactory<? extends HttpExchangeAdapter> builder(AdapterType type) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new RestTemplateAdapterWrapper();
            case 1 -> new WebClientAdapterWrapper();
            case 2 -> new RestClientAdapterWrapper();
            case 3 -> {
                if (ClassUtils.isPresent((String)"org.springframework.web.reactive.function.client.WebClient")) {
                    yield new WebClientAdapterWrapper();
                }
                if (ClassUtils.isPresent((String)"org.springframework.web.client.RestClient")) {
                    yield new RestClientAdapterWrapper();
                }
                if (ClassUtils.isPresent((String)"org.springframework.web.client.RestTemplate")) {
                    yield new RestTemplateAdapterWrapper();
                }
                throw new UnsupportedOperationException("\u7f3a\u5c11\u6784\u5efaHttpExchangeAdapter\u7684\u7c7b\u4fe1\u606f");
            }
        };
    }

    private static class RestTemplateAdapterWrapper
    implements AdapterFactory<RestTemplateAdapter> {
        private RestTemplateAdapterWrapper() {
        }

        @Override
        public RestTemplateAdapter create(BeanFactory beanFactory) {
            RestTemplate restTemplate = (RestTemplate)beanFactory.getBeanProvider(RestTemplate.class).getIfAvailable(() -> ((RestTemplateBuilder)beanFactory.getBean(RestTemplateBuilder.class)).build());
            return RestTemplateAdapter.create((RestTemplate)restTemplate);
        }
    }

    private static class WebClientAdapterWrapper
    implements AdapterFactory<WebClientAdapter> {
        private WebClientAdapterWrapper() {
        }

        @Override
        public WebClientAdapter create(BeanFactory beanFactory) {
            WebClient webClient = (WebClient)beanFactory.getBeanProvider(WebClient.class).getIfAvailable(() -> ((WebClient.Builder)beanFactory.getBean(WebClient.Builder.class)).build());
            return WebClientAdapter.create((WebClient)webClient);
        }
    }

    private static class RestClientAdapterWrapper
    implements AdapterFactory<RestClientAdapter> {
        private RestClientAdapterWrapper() {
        }

        @Override
        public RestClientAdapter create(BeanFactory beanFactory) {
            RestClient restClient = (RestClient)beanFactory.getBeanProvider(RestClient.class).getIfAvailable(() -> ((RestClient.Builder)beanFactory.getBean(RestClient.Builder.class)).build());
            return RestClientAdapter.create((RestClient)restClient);
        }
    }
}

