/*
 * Decompiled with CFR 0.152.
 */
package com.livk.autoconfigure.http.factory;

import com.livk.autoconfigure.http.HttpServiceProxyFactoryCustomizer;
import com.livk.autoconfigure.http.factory.AdapterFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.lang.NonNull;
import org.springframework.web.service.invoker.HttpExchangeAdapter;
import org.springframework.web.service.invoker.HttpServiceProxyFactory;

public class HttpFactoryBean
implements FactoryBean<Object>,
BeanFactoryAware {
    private BeanFactory beanFactory;
    private Class<?> type;
    private AdapterFactory<? extends HttpExchangeAdapter> adapterFactory;
    private ObjectProvider<HttpServiceProxyFactoryCustomizer> customizers;

    public Object getObject() {
        HttpExchangeAdapter adapter = this.adapterFactory.create(this.beanFactory);
        HttpServiceProxyFactory.Builder builder = HttpServiceProxyFactory.builderFor((HttpExchangeAdapter)adapter);
        this.customizers.orderedStream().forEach(customizer -> customizer.customize(builder));
        HttpServiceProxyFactory proxyFactory = builder.build();
        return proxyFactory.createClient(this.type);
    }

    public Class<?> getObjectType() {
        return this.type;
    }

    public void setBeanFactory(@NonNull BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        this.customizers = beanFactory.getBeanProvider(HttpServiceProxyFactoryCustomizer.class);
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public void setAdapterFactory(AdapterFactory<? extends HttpExchangeAdapter> adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    public void setCustomizers(ObjectProvider<HttpServiceProxyFactoryCustomizer> customizers) {
        this.customizers = customizers;
    }
}

