/*
 * Decompiled with CFR 0.152.
 */
package com.livk.autoconfigure.limit;

import com.livk.autoconfigure.redisson.RedissonAutoConfiguration;
import com.livk.context.limit.LimitExecutor;
import com.livk.context.limit.executor.RedissonLimitExecutor;
import com.livk.context.limit.interceptor.LimitInterceptor;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
public class LimitAutoConfiguration {
    @Bean
    public LimitInterceptor limitInterceptor(ObjectProvider<LimitExecutor> provider) {
        return new LimitInterceptor(provider);
    }

    @ConditionalOnClass(value={RedissonClient.class})
    @AutoConfiguration(after={RedissonAutoConfiguration.class}, afterName={"org.redisson.spring.starter.RedissonAutoConfiguration"})
    public static class RedissonLimitConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public LimitExecutor redissonLimitExecutor(RedissonClient redissonClient) {
            return new RedissonLimitExecutor(redissonClient);
        }
    }
}

