/*
 * Decompiled with CFR 0.152.
 */
package com.livk.autoconfigure.lock;

import com.livk.autoconfigure.curator.CuratorAutoConfiguration;
import com.livk.autoconfigure.redisson.RedissonAutoConfiguration;
import com.livk.context.lock.DistributedLock;
import com.livk.context.lock.intercept.LockInterceptor;
import com.livk.context.lock.support.CuratorLock;
import com.livk.context.lock.support.LocalLock;
import com.livk.context.lock.support.RedissonLock;
import org.apache.curator.framework.CuratorFramework;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(name={"com.livk.lock.marker.LockMarker"})
public class LockAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public LockInterceptor lockInterceptor(ObjectProvider<DistributedLock> distributedLockProvider) {
        return new LockInterceptor(distributedLockProvider);
    }

    @Bean
    public DistributedLock localLock() {
        return new LocalLock();
    }

    @ConditionalOnClass(value={CuratorFramework.class})
    @AutoConfiguration(after={CuratorAutoConfiguration.class})
    public static class CuratorLockAutoConfiguration {
        @Bean
        public DistributedLock redissonLock(CuratorFramework curatorFramework) {
            return new CuratorLock(curatorFramework);
        }
    }

    @ConditionalOnClass(value={RedissonClient.class})
    @AutoConfiguration(after={RedissonAutoConfiguration.class}, afterName={"org.redisson.spring.starter.RedissonAutoConfiguration"})
    public static class RedissonLockAutoConfiguration {
        @Bean
        public DistributedLock redissonLock(RedissonClient redissonClient) {
            return new RedissonLock(redissonClient);
        }
    }
}

