/*
 * Decompiled with CFR 0.152.
 */
package com.livk.autoconfigure.mapstruct;

import com.livk.context.mapstruct.GenericMapstructService;
import com.livk.context.mapstruct.repository.ConverterRepository;
import com.livk.context.mapstruct.repository.InMemoryConverterRepository;
import com.livk.context.mapstruct.repository.MapstructLocator;
import com.livk.context.mapstruct.repository.SpringMapstructLocator;
import org.mapstruct.factory.Mappers;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={Mappers.class})
public class MapstructAutoConfiguration {
    @Bean
    public GenericMapstructService genericMapstructService(ConverterRepository repository) {
        return new GenericMapstructService(repository);
    }

    @Bean
    @ConditionalOnMissingBean
    public ConverterRepository converterRepository() {
        return new InMemoryConverterRepository();
    }

    @Bean
    public MapstructLocator springMapstructLocator() {
        return new SpringMapstructLocator();
    }
}

