/*
 * Decompiled with CFR 0.152.
 */
package com.livk.autoconfigure.mybatisplugins.monitor.interceptor;

import com.livk.autoconfigure.mybatisplugins.monitor.MybatisLogMonitorProperties;
import com.livk.autoconfigure.mybatisplugins.monitor.event.MonitorSQLInfo;
import com.livk.autoconfigure.mybatisplugins.monitor.event.MonitorSQLTimeOutEvent;
import com.livk.commons.spring.context.SpringContextHolder;
import com.livk.commons.util.SqlParserUtils;
import java.sql.Connection;
import java.time.temporal.ChronoUnit;
import java.util.Properties;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class MybatisLogMonitor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(MybatisLogMonitor.class);
    private Properties properties;

    public Object intercept(Invocation invocation) throws Throwable {
        long start = System.currentTimeMillis();
        Object proceed = invocation.proceed();
        long time = System.currentTimeMillis() - start;
        String sql = SqlParserUtils.formatSql((String)((StatementHandler)invocation.getTarget()).getBoundSql().getSql());
        if (time > this.timeOut()) {
            log.warn("{SQL\u8d85\u65f6 SQL:[{}],Time:[{}ms]}", (Object)sql, (Object)time);
            MonitorSQLInfo monitorSQLInfo = new MonitorSQLInfo(sql, time, proceed);
            SpringContextHolder.publishEvent((ApplicationEvent)new MonitorSQLTimeOutEvent(monitorSQLInfo));
        }
        return proceed;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    private long timeOut() {
        return ((ChronoUnit)this.properties.get(MybatisLogMonitorProperties.unitName())).getDuration().toMillis() * (Long)this.properties.get(MybatisLogMonitorProperties.timeOutName());
    }
}

