/*
 * Decompiled with CFR 0.152.
 */
package com.livk.autoconfigure.mybatisplugins.type;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.livk.context.mybatisplugins.type.mysql.MysqlJsonTypeHandler;
import com.livk.context.mybatisplugins.type.postgresql.PostgresJsonTypeHandler;
import com.mysql.cj.jdbc.Driver;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.TypeHandler;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.boot.autoconfigure.ConfigurationCustomizer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class, ConfigurationCustomizer.class})
public class MybatisTypeHandlerAutoConfiguration {

    @AutoConfiguration
    @ConditionalOnClass(value={org.postgresql.Driver.class})
    public static class PostgresqlMybatisTypeHandlerAutoConfiguration {
        @Bean
        public ConfigurationCustomizer postgresqlConfigurationCustomizer(ObjectProvider<ObjectMapper> mapperProvider) {
            ObjectMapper mapper = (ObjectMapper)mapperProvider.getIfUnique(JsonMapper::new);
            return configuration -> configuration.getTypeHandlerRegistry().register((TypeHandler)new PostgresJsonTypeHandler(mapper));
        }
    }

    @AutoConfiguration
    @ConditionalOnClass(value={Driver.class})
    public static class MysqlMybatisTypeHandlerAutoConfiguration {
        @Bean
        public ConfigurationCustomizer mysqlConfigurationCustomizer(ObjectProvider<ObjectMapper> mapperProvider) {
            ObjectMapper mapper = (ObjectMapper)mapperProvider.getIfUnique(JsonMapper::new);
            return configuration -> configuration.getTypeHandlerRegistry().register((TypeHandler)new MysqlJsonTypeHandler(mapper));
        }
    }
}

