/*
 * Decompiled with CFR 0.152.
 */
package com.livk.autoconfigure.oss;

import com.aliyun.oss.OSS;
import com.livk.autoconfigure.oss.OSSProperties;
import com.livk.autoconfigure.oss.support.AbstractService;
import com.livk.autoconfigure.oss.support.OSSTemplate;
import com.livk.autoconfigure.oss.support.aliyun.AliyunOSSService;
import com.livk.autoconfigure.oss.support.minio.MinioService;
import io.minio.MinioClient;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(name={"com.livk.oss.marker.OSSMarker"})
@EnableConfigurationProperties(value={OSSProperties.class})
public class OSSAutoConfiguration {
    @Bean(destroyMethod="close")
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={AbstractService.class})
    public OSSTemplate ossTemplate(AbstractService<?> abstractService) {
        return new OSSTemplate(abstractService);
    }

    @AutoConfiguration
    @ConditionalOnClass(value={OSS.class})
    public static class AliyunOSSAutoConfiguration {
        @Bean(destroyMethod="close")
        @ConditionalOnMissingBean(value={AbstractService.class})
        public AliyunOSSService aliyunOSSService() {
            return new AliyunOSSService();
        }
    }

    @AutoConfiguration
    @ConditionalOnClass(value={MinioClient.class})
    public static class MinioOSSAutoConfiguration {
        @Bean(destroyMethod="close")
        @ConditionalOnMissingBean(value={AbstractService.class})
        public MinioService minioService() {
            return new MinioService();
        }
    }
}

