/*
 * Decompiled with CFR 0.152.
 */
package com.livk.autoconfigure.oss;

import java.net.URI;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.Name;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="spring.oss")
public class OSSProperties {
    public static final String PREFIX = "spring.oss";
    private String accessKey;
    private String secretKey;
    private String prefix;
    private String endpoint;
    private String region;

    public OSSProperties(@Name(value="url") URI url, @Name(value="accessKey") String accessKey, @Name(value="secretKey") String secretKey, @Name(value="region") String region) {
        Assert.notNull((Object)url, (String)"url not be blank");
        Assert.hasText((String)accessKey, (String)"accessKey not be blank");
        Assert.hasText((String)secretKey, (String)"secretKey not be blank");
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.prefix = this.prefix(url);
        this.endpoint = this.endpoint(url);
        this.region = region;
    }

    private String endpoint(URI url) {
        return url.getSchemeSpecificPart();
    }

    private String prefix(URI uri) {
        String scheme = uri.getScheme();
        if (StringUtils.hasText((String)scheme)) {
            return scheme;
        }
        throw new IllegalArgumentException("url\u7f3a\u5c11\u524d\u7f00!");
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getRegion() {
        return this.region;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OSSProperties)) {
            return false;
        }
        OSSProperties other = (OSSProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$accessKey = this.getAccessKey();
        String other$accessKey = other.getAccessKey();
        if (this$accessKey == null ? other$accessKey != null : !this$accessKey.equals(other$accessKey)) {
            return false;
        }
        String this$secretKey = this.getSecretKey();
        String other$secretKey = other.getSecretKey();
        if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        return !(this$region == null ? other$region != null : !this$region.equals(other$region));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OSSProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $accessKey = this.getAccessKey();
        result = result * 59 + ($accessKey == null ? 43 : $accessKey.hashCode());
        String $secretKey = this.getSecretKey();
        result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        return result;
    }

    public String toString() {
        return "OSSProperties(accessKey=" + this.getAccessKey() + ", secretKey=" + this.getSecretKey() + ", prefix=" + this.getPrefix() + ", endpoint=" + this.getEndpoint() + ", region=" + this.getRegion() + ")";
    }
}

