/*
 * Decompiled with CFR 0.152.
 */
package com.livk.autoconfigure.oss.support;

import com.livk.autoconfigure.oss.client.OSSClientFactory;
import com.livk.autoconfigure.oss.client.OSSClientFactoryLoader;
import com.livk.autoconfigure.oss.exception.OSSClientFactoryNotFoundException;
import com.livk.autoconfigure.oss.support.aliyun.AliyunClientFactory;
import com.livk.autoconfigure.oss.support.minio.MinioClientFactory;
import com.livk.commons.util.ClassUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.support.SpringFactoriesLoader;

class OSSClientFactoryPatternResolver
implements OSSClientFactoryLoader {
    private static final Logger log = LoggerFactory.getLogger(OSSClientFactoryPatternResolver.class);
    private static final Set<OSSClientFactory<?>> FACTORIES = new HashSet();

    OSSClientFactoryPatternResolver() {
    }

    private static void register() {
        if (ClassUtils.isPresent((String)"io.minio.MinioClient")) {
            FACTORIES.add(new MinioClientFactory());
        }
        if (ClassUtils.isPresent((String)"com.aliyun.oss.OSS")) {
            FACTORIES.add(new AliyunClientFactory());
        }
    }

    @Override
    public <T> OSSClientFactory<T> loader(String prefix) {
        for (OSSClientFactory<?> factory : FACTORIES) {
            if (!factory.name().equals(prefix)) continue;
            return factory;
        }
        if (log.isDebugEnabled()) {
            log.debug("oss factory\u5339\u914d\u5931\u8d25, \u52a0\u8f7dSpring SPI");
        }
        List factoryLoaders = SpringFactoriesLoader.loadFactories(OSSClientFactoryLoader.class, (ClassLoader)ClassUtils.getDefaultClassLoader());
        for (OSSClientFactoryLoader factoryLoader : factoryLoaders) {
            OSSClientFactory clientFactory = factoryLoader.loader(prefix);
            if (clientFactory == null) continue;
            return clientFactory;
        }
        throw new OSSClientFactoryNotFoundException(prefix + " oss factory\u5339\u914d\u5931\u8d25");
    }

    static {
        OSSClientFactoryPatternResolver.register();
    }
}

