/*
 * Decompiled with CFR 0.152.
 */
package com.livk.autoconfigure.oss.support;

import com.livk.autoconfigure.oss.support.AbstractService;
import com.livk.autoconfigure.oss.support.OSSOperations;
import java.io.InputStream;
import java.util.List;

public final class OSSTemplate
implements OSSOperations {
    private final AbstractService<?> ossService;

    @Override
    public boolean exist(String bucketName) {
        return this.ossService.exist(bucketName);
    }

    @Override
    public void createBucket(String bucketName) {
        this.ossService.createBucket(bucketName);
    }

    @Override
    public List<String> allBuckets() {
        return this.ossService.allBuckets();
    }

    @Override
    public void removeObj(String bucketName) {
        this.ossService.removeObj(bucketName);
    }

    public void removeBucketAndObj(String bucketName) {
        if (this.exist(bucketName)) {
            this.removeObjs(bucketName);
            this.removeObj(bucketName);
        }
    }

    @Override
    public boolean exist(String bucketName, String fileName) {
        return this.ossService.exist(bucketName, fileName);
    }

    @Override
    public void upload(String bucketName, String fileName, InputStream inputStream) {
        this.ossService.upload(bucketName, fileName, inputStream);
    }

    @Override
    public InputStream download(String bucketName, String fileName) {
        return this.ossService.download(bucketName, fileName);
    }

    @Override
    public void removeObj(String bucketName, String fileName) {
        this.ossService.removeObj(bucketName, fileName);
    }

    @Override
    public List<String> getAllObj(String bucketName) {
        return this.ossService.getAllObj(bucketName);
    }

    @Override
    public String getStrUrl(String bucketName, String fileName) {
        return this.ossService.getStrUrl(bucketName, fileName);
    }

    @Override
    public String getStrUrl(String bucketName, String fileName, int expires) {
        return this.ossService.getStrUrl(bucketName, fileName, expires);
    }

    @Override
    public void close() throws Exception {
        this.ossService.close();
    }

    public String getExternalLink(String bucketName, String fileName) {
        String url = this.getStrUrl(bucketName, fileName);
        int index = url.indexOf(63);
        if (index == -1) {
            return url;
        }
        return url.substring(0, index);
    }

    public OSSTemplate(AbstractService<?> ossService) {
        this.ossService = ossService;
    }
}

