/*
 * Decompiled with CFR 0.152.
 */
package com.livk.autoconfigure.oss.support.aliyun;

import com.aliyun.oss.OSS;
import com.aliyun.oss.model.Bucket;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.SetBucketCORSRequest;
import com.livk.autoconfigure.oss.support.AbstractService;
import com.livk.commons.util.DateUtils;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.List;

public class AliyunOSSService
extends AbstractService<OSS> {
    @Override
    public boolean exist(String bucketName) {
        return ((OSS)this.client).doesBucketExist(bucketName);
    }

    @Override
    public void createBucket(String bucketName) {
        if (!((OSS)this.client).doesBucketExist(bucketName)) {
            ((OSS)this.client).createBucket(bucketName);
            SetBucketCORSRequest request = new SetBucketCORSRequest(bucketName);
            SetBucketCORSRequest.CORSRule rule = new SetBucketCORSRequest.CORSRule();
            rule.addAllowedMethod("GET");
            rule.addAllowedMethod("POST");
            rule.addAllowedMethod("PUT");
            rule.addAllowedMethod("DELETE");
            rule.addAllowdOrigin("*");
            request.addCorsRule(rule);
            ((OSS)this.client).setBucketCORS(request);
            ((OSS)this.client).setBucketAcl(bucketName, CannedAccessControlList.PublicRead);
        }
    }

    @Override
    public List<String> allBuckets() {
        return ((OSS)this.client).listBuckets().stream().map(Bucket::getName).toList();
    }

    @Override
    public void removeObj(String bucketName) {
        ((OSS)this.client).deleteBucket(bucketName);
    }

    @Override
    public boolean exist(String bucketName, String fileName) {
        ((OSS)this.client).doesObjectExist(bucketName, fileName);
        return false;
    }

    @Override
    public void upload(String bucketName, String fileName, InputStream inputStream) {
        ((OSS)this.client).putObject(bucketName, fileName, inputStream);
    }

    @Override
    public InputStream download(String bucketName, String fileName) {
        return ((OSS)this.client).getObject(bucketName, fileName).getObjectContent();
    }

    @Override
    public void removeObj(String bucketName, String fileName) {
        ((OSS)this.client).deleteObject(bucketName, fileName);
    }

    @Override
    public String getStrUrl(String bucketName, String fileName) {
        return this.getStrUrl(bucketName, fileName, 7);
    }

    @Override
    public String getStrUrl(String bucketName, String fileName, int expires) {
        LocalDateTime time = LocalDateTime.now().plusDays(expires);
        return ((OSS)this.client).generatePresignedUrl(bucketName, fileName, DateUtils.date((LocalDateTime)time)).toString();
    }

    @Override
    public List<String> getAllObj(String bucketName) {
        return ((OSS)this.client).listObjects(bucketName).getObjectSummaries().stream().map(OSSObjectSummary::getKey).toList();
    }

    @Override
    public void close() throws Exception {
        ((OSS)this.client).shutdown();
    }
}

