/*
 * Decompiled with CFR 0.152.
 */
package com.livk.autoconfigure.oss.support.minio;

import com.livk.autoconfigure.oss.support.AbstractService;
import io.minio.BucketExistsArgs;
import io.minio.GetObjectArgs;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.ListObjectsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveBucketArgs;
import io.minio.RemoveObjectArgs;
import io.minio.Result;
import io.minio.SetBucketPolicyArgs;
import io.minio.StatObjectArgs;
import io.minio.http.Method;
import io.minio.messages.Bucket;
import io.minio.messages.Item;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class MinioService
extends AbstractService<MinioClient> {
    private static final String POLICY_JSON = "{  \"Statement\": [    {      \"Action\": \"s3:GetObject\",      \"Effect\": \"Allow\",      \"Principal\": \"*\",      \"Resource\": [        \"arn:aws:s3:::${bucketName}/*\"      ]    }  ],  \"Version\": \"2012-10-17\"}";

    @Override
    public boolean exist(String bucketName) {
        return ((MinioClient)this.client).bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build());
    }

    @Override
    public void createBucket(String bucketName) {
        if (!this.exist(bucketName)) {
            ((MinioClient)this.client).makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).build());
            String config = POLICY_JSON.replaceAll("\\$\\{bucketName}", bucketName);
            ((MinioClient)this.client).setBucketPolicy((SetBucketPolicyArgs)((SetBucketPolicyArgs.Builder)SetBucketPolicyArgs.builder().bucket(bucketName)).config(config).build());
        }
    }

    @Override
    public List<String> allBuckets() {
        return ((MinioClient)this.client).listBuckets().stream().map(Bucket::name).collect(Collectors.toList());
    }

    @Override
    public void removeObj(String bucketName) {
        ((MinioClient)this.client).removeBucket((RemoveBucketArgs)((RemoveBucketArgs.Builder)RemoveBucketArgs.builder().bucket(bucketName)).build());
    }

    @Override
    public boolean exist(String bucketName, String fileName) {
        try {
            return ((MinioClient)this.client).statObject((StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(bucketName)).object(fileName)).build()) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void upload(String bucketName, String fileName, InputStream inputStream) {
        ((MinioClient)this.client).putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(fileName)).stream(inputStream, (long)inputStream.available(), -1L).build());
    }

    @Override
    public InputStream download(String bucketName, String fileName) {
        return ((MinioClient)this.client).getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(fileName)).build());
    }

    @Override
    public void removeObj(String bucketName, String fileName) {
        ((MinioClient)this.client).removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucketName)).object(fileName)).build());
    }

    @Override
    public String getStrUrl(String bucketName, String fileName) {
        return ((MinioClient)this.client).getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().bucket(bucketName)).object(fileName)).method(Method.GET).build());
    }

    @Override
    public String getStrUrl(String bucketName, String fileName, int expires) {
        return ((MinioClient)this.client).getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().bucket(bucketName)).object(fileName)).method(Method.GET).expiry(expires).build());
    }

    @Override
    public List<String> getAllObj(String bucketName) {
        Iterable results = ((MinioClient)this.client).listObjects((ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(bucketName)).build());
        ArrayList<String> list = new ArrayList<String>();
        for (Result result : results) {
            list.add(((Item)result.get()).objectName());
        }
        return list;
    }

    @Override
    public void close() {
        this.client = null;
    }
}

