/*
 * Decompiled with CFR 0.152.
 */
package com.livk.autoconfigure.qrcode;

import com.livk.context.qrcode.QRCodeGenerator;
import com.livk.context.qrcode.resolver.QRCodeMethodReturnValueHandler;
import com.livk.context.qrcode.resolver.ReactiveQRCodeMethodReturnValueHandler;
import com.livk.context.qrcode.support.GoogleQRCodeGenerator;
import java.util.List;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@AutoConfiguration
@ConditionalOnClass(name={"com.google.zxing.common.BitMatrix"})
public class QRCodeAutoConfiguration {
    @Bean
    public QRCodeGenerator googleQRCodeGenerator(Jackson2ObjectMapperBuilder builder) {
        return new GoogleQRCodeGenerator(builder.build());
    }

    @AutoConfiguration
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    public static class WebFluxQRCodeAutoConfiguration
    implements WebFluxConfigurer {
        @Bean
        public ReactiveQRCodeMethodReturnValueHandler reactiveQRCodeMethodReturnValueHandler(QRCodeGenerator qrCodeGenerator) {
            return new ReactiveQRCodeMethodReturnValueHandler(qrCodeGenerator);
        }
    }

    @AutoConfiguration
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    public static class WebMvcQRCodeAutoConfiguration
    implements WebMvcConfigurer {
        private final QRCodeGenerator qrCodeGenerator;

        public void addReturnValueHandlers(List<HandlerMethodReturnValueHandler> handlers) {
            handlers.add((HandlerMethodReturnValueHandler)new QRCodeMethodReturnValueHandler(this.qrCodeGenerator));
        }

        public WebMvcQRCodeAutoConfiguration(QRCodeGenerator qrCodeGenerator) {
            this.qrCodeGenerator = qrCodeGenerator;
        }
    }
}

