/*
 * Decompiled with CFR 0.152.
 */
package com.livk.autoconfigure.redis;

import com.livk.context.redis.JacksonSerializerUtils;
import com.livk.context.redis.ReactiveRedisOps;
import com.livk.context.redis.RedisOps;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisReactiveAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import reactor.core.publisher.Flux;

@ConditionalOnClass(value={RedisOperations.class})
@AutoConfiguration(before={RedisAutoConfiguration.class})
public class CustomizeRedisAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public RedisOps redisOps(RedisConnectionFactory redisConnectionFactory) {
        return new RedisOps(redisConnectionFactory);
    }

    @AutoConfiguration(before={RedisReactiveAutoConfiguration.class})
    @ConditionalOnClass(value={ReactiveRedisConnectionFactory.class, ReactiveRedisTemplate.class, Flux.class})
    public static class CustomizeReactiveRedisAutoConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public ReactiveRedisOps reactiveRedisOps(ReactiveRedisConnectionFactory redisConnectionFactory) {
            RedisSerializationContext serializationContext = RedisSerializationContext.newSerializationContext().key(RedisSerializer.string()).value(JacksonSerializerUtils.json()).hashKey(RedisSerializer.string()).hashValue(JacksonSerializerUtils.json()).build();
            return new ReactiveRedisOps(redisConnectionFactory, serializationContext);
        }
    }
}

