/*
 * Decompiled with CFR 0.152.
 */
package com.livk.autoconfigure.redisearch;

import com.livk.autoconfigure.redisearch.RediSearchProperties;
import com.livk.autoconfigure.redisearch.RediSearchSupport;
import com.livk.autoconfigure.redisearch.StatefulConnectionConfiguration;
import com.livk.autoconfigure.redisearch.codec.JdkRedisCodec;
import com.livk.autoconfigure.redisearch.customizer.ClientOptionsBuilderCustomizer;
import com.livk.autoconfigure.redisearch.customizer.ClientResourcesBuilderCustomizer;
import com.livk.autoconfigure.redisearch.customizer.ClusterClientOptionsBuilderCustomizer;
import com.redis.lettucemod.RedisModulesClient;
import com.redis.lettucemod.api.StatefulRedisModulesConnection;
import com.redis.lettucemod.cluster.RedisModulesClusterClient;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.RedisURI;
import io.lettuce.core.cluster.ClusterClientOptions;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.resource.ClientResources;
import java.util.List;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false, enforceUniqueMethods=false)
@ConditionalOnClass(value={RedisModulesClient.class})
@EnableConfigurationProperties(value={RediSearchProperties.class})
public class RediSearchAutoConfiguration {
    @Bean(destroyMethod="shutdown")
    public ClientResources clientResources(ObjectProvider<ClientResourcesBuilderCustomizer> providers) {
        ClientResources.Builder builder = ClientResources.builder();
        providers.orderedStream().forEach(customizer -> customizer.customize(builder));
        return builder.build();
    }

    @Bean(destroyMethod="close")
    @ConditionalOnProperty(name={"spring.redisearch.cluster.enabled"}, havingValue="false", matchIfMissing=true)
    public RedisModulesClient redisModulesClient(ClientResources clientResources, RediSearchProperties properties, ObjectProvider<ClientOptionsBuilderCustomizer> providers) {
        RedisURI redisURI = RediSearchSupport.create(properties);
        RedisModulesClient client = RedisModulesClient.create((ClientResources)clientResources, (RedisURI)redisURI);
        ClientOptions.Builder builder = client.getOptions().mutate();
        providers.orderedStream().forEach(customizer -> customizer.customize(builder));
        client.setOptions(builder.build());
        return client;
    }

    @Bean(destroyMethod="close")
    @ConditionalOnProperty(name={"spring.redisearch.cluster.enabled"}, havingValue="true")
    public RedisModulesClusterClient redisModulesClusterClient(ClientResources clientResources, RediSearchProperties properties, ObjectProvider<ClusterClientOptionsBuilderCustomizer> providers) {
        List<RedisURI> redisURIList = RediSearchSupport.createCluster(properties);
        RedisModulesClusterClient clusterClient = RedisModulesClusterClient.create((ClientResources)clientResources, redisURIList);
        ClusterClientOptions.Builder builder = ((ClusterClientOptions)clusterClient.getOptions()).mutate();
        if (properties.getCluster().getMaxRedirects() != null) {
            builder.maxRedirects(properties.getCluster().getMaxRedirects().intValue());
        }
        providers.orderedStream().forEach(customizer -> customizer.customize(builder));
        clusterClient.setOptions(builder.build());
        return clusterClient;
    }

    @Bean
    @ConditionalOnMissingBean
    public GenericObjectPoolConfig<?> poolConfig(RediSearchProperties properties) {
        return RediSearchSupport.withPoolConfig(properties);
    }

    @AutoConfiguration
    @Import(value={StatefulConnectionConfiguration.class})
    @ConditionalOnProperty(name={"spring.redisearch.cluster.enabled"}, havingValue="true")
    public static class RediSearchClusterPoolConfiguration {
        @Bean(destroyMethod="close")
        public GenericObjectPool<StatefulRedisModulesConnection<String, String>> stringGenericObjectPool(RedisModulesClusterClient redisModulesClusterClient, GenericObjectPoolConfig<StatefulRedisModulesConnection<String, String>> config) {
            return RediSearchSupport.pool(() -> ((RedisModulesClusterClient)redisModulesClusterClient).connect(), config);
        }

        @Bean(destroyMethod="close")
        public GenericObjectPool<StatefulRedisModulesConnection<String, Object>> genericObjectPool(RedisModulesClusterClient redisModulesClusterClient, GenericObjectPoolConfig<StatefulRedisModulesConnection<String, Object>> config) {
            return RediSearchSupport.pool(() -> redisModulesClusterClient.connect((RedisCodec)new JdkRedisCodec()), config);
        }
    }

    @AutoConfiguration
    @Import(value={StatefulConnectionConfiguration.class})
    @ConditionalOnProperty(name={"spring.redisearch.cluster.enabled"}, havingValue="false", matchIfMissing=true)
    public static class RediSearchPoolConfiguration {
        @Bean(destroyMethod="close")
        public GenericObjectPool<StatefulRedisModulesConnection<String, String>> stringGenericObjectPool(RedisModulesClient redisModulesClient, GenericObjectPoolConfig<StatefulRedisModulesConnection<String, String>> config) {
            return RediSearchSupport.pool(() -> ((RedisModulesClient)redisModulesClient).connect(), config);
        }

        @Bean(destroyMethod="close")
        public GenericObjectPool<StatefulRedisModulesConnection<String, Object>> genericObjectPool(RedisModulesClient redisModulesClient, GenericObjectPoolConfig<StatefulRedisModulesConnection<String, Object>> config) {
            return RediSearchSupport.pool(() -> redisModulesClient.connect((RedisCodec)new JdkRedisCodec()), config);
        }
    }
}

