/*
 * Decompiled with CFR 0.152.
 */
package com.livk.autoconfigure.redisearch;

import java.time.Duration;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="spring.redisearch")
public class RediSearchProperties {
    private final Boolean ssl = false;
    private final Pool pool = new Pool();
    private int database = 0;
    private String host = "localhost";
    private String username;
    private String password;
    private int port = 6379;
    private Duration timeout;
    private String clientName;
    private Cluster cluster;

    public Boolean getSsl() {
        return this.ssl;
    }

    public Pool getPool() {
        return this.pool;
    }

    public int getDatabase() {
        return this.database;
    }

    public String getHost() {
        return this.host;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPort() {
        return this.port;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public String getClientName() {
        return this.clientName;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public void setDatabase(int database) {
        this.database = database;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RediSearchProperties)) {
            return false;
        }
        RediSearchProperties other = (RediSearchProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDatabase() != other.getDatabase()) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        Boolean this$ssl = this.getSsl();
        Boolean other$ssl = other.getSsl();
        if (this$ssl == null ? other$ssl != null : !((Object)this$ssl).equals(other$ssl)) {
            return false;
        }
        Pool this$pool = this.getPool();
        Pool other$pool = other.getPool();
        if (this$pool == null ? other$pool != null : !((Object)this$pool).equals(other$pool)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        Duration this$timeout = this.getTimeout();
        Duration other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        String this$clientName = this.getClientName();
        String other$clientName = other.getClientName();
        if (this$clientName == null ? other$clientName != null : !this$clientName.equals(other$clientName)) {
            return false;
        }
        Cluster this$cluster = this.getCluster();
        Cluster other$cluster = other.getCluster();
        return !(this$cluster == null ? other$cluster != null : !((Object)this$cluster).equals(other$cluster));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RediSearchProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDatabase();
        result = result * 59 + this.getPort();
        Boolean $ssl = this.getSsl();
        result = result * 59 + ($ssl == null ? 43 : ((Object)$ssl).hashCode());
        Pool $pool = this.getPool();
        result = result * 59 + ($pool == null ? 43 : ((Object)$pool).hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        Duration $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        String $clientName = this.getClientName();
        result = result * 59 + ($clientName == null ? 43 : $clientName.hashCode());
        Cluster $cluster = this.getCluster();
        result = result * 59 + ($cluster == null ? 43 : ((Object)$cluster).hashCode());
        return result;
    }

    public String toString() {
        return "RediSearchProperties(ssl=" + this.getSsl() + ", pool=" + String.valueOf(this.getPool()) + ", database=" + this.getDatabase() + ", host=" + this.getHost() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", port=" + this.getPort() + ", timeout=" + String.valueOf(this.getTimeout()) + ", clientName=" + this.getClientName() + ", cluster=" + String.valueOf(this.getCluster()) + ")";
    }

    public static class Pool {
        private Boolean enabled;
        private int maxIdle = 8;
        private int minIdle = 0;
        private int maxActive = 8;
        private Duration maxWait = Duration.ofMillis(-1L);

        public Boolean getEnabled() {
            return this.enabled;
        }

        public int getMaxIdle() {
            return this.maxIdle;
        }

        public int getMinIdle() {
            return this.minIdle;
        }

        public int getMaxActive() {
            return this.maxActive;
        }

        public Duration getMaxWait() {
            return this.maxWait;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public void setMaxIdle(int maxIdle) {
            this.maxIdle = maxIdle;
        }

        public void setMinIdle(int minIdle) {
            this.minIdle = minIdle;
        }

        public void setMaxActive(int maxActive) {
            this.maxActive = maxActive;
        }

        public void setMaxWait(Duration maxWait) {
            this.maxWait = maxWait;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pool)) {
                return false;
            }
            Pool other = (Pool)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMaxIdle() != other.getMaxIdle()) {
                return false;
            }
            if (this.getMinIdle() != other.getMinIdle()) {
                return false;
            }
            if (this.getMaxActive() != other.getMaxActive()) {
                return false;
            }
            Boolean this$enabled = this.getEnabled();
            Boolean other$enabled = other.getEnabled();
            if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                return false;
            }
            Duration this$maxWait = this.getMaxWait();
            Duration other$maxWait = other.getMaxWait();
            return !(this$maxWait == null ? other$maxWait != null : !((Object)this$maxWait).equals(other$maxWait));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Pool;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMaxIdle();
            result = result * 59 + this.getMinIdle();
            result = result * 59 + this.getMaxActive();
            Boolean $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            Duration $maxWait = this.getMaxWait();
            result = result * 59 + ($maxWait == null ? 43 : ((Object)$maxWait).hashCode());
            return result;
        }

        public String toString() {
            return "RediSearchProperties.Pool(enabled=" + this.getEnabled() + ", maxIdle=" + this.getMaxIdle() + ", minIdle=" + this.getMinIdle() + ", maxActive=" + this.getMaxActive() + ", maxWait=" + String.valueOf(this.getMaxWait()) + ")";
        }
    }

    public static class Cluster {
        private Boolean enabled;
        private List<String> nodes;
        private Integer maxRedirects;

        public Boolean getEnabled() {
            return this.enabled;
        }

        public List<String> getNodes() {
            return this.nodes;
        }

        public Integer getMaxRedirects() {
            return this.maxRedirects;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public void setNodes(List<String> nodes) {
            this.nodes = nodes;
        }

        public void setMaxRedirects(Integer maxRedirects) {
            this.maxRedirects = maxRedirects;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Cluster)) {
                return false;
            }
            Cluster other = (Cluster)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enabled = this.getEnabled();
            Boolean other$enabled = other.getEnabled();
            if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                return false;
            }
            Integer this$maxRedirects = this.getMaxRedirects();
            Integer other$maxRedirects = other.getMaxRedirects();
            if (this$maxRedirects == null ? other$maxRedirects != null : !((Object)this$maxRedirects).equals(other$maxRedirects)) {
                return false;
            }
            List<String> this$nodes = this.getNodes();
            List<String> other$nodes = other.getNodes();
            return !(this$nodes == null ? other$nodes != null : !((Object)this$nodes).equals(other$nodes));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Cluster;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            Integer $maxRedirects = this.getMaxRedirects();
            result = result * 59 + ($maxRedirects == null ? 43 : ((Object)$maxRedirects).hashCode());
            List<String> $nodes = this.getNodes();
            result = result * 59 + ($nodes == null ? 43 : ((Object)$nodes).hashCode());
            return result;
        }

        public String toString() {
            return "RediSearchProperties.Cluster(enabled=" + this.getEnabled() + ", nodes=" + String.valueOf(this.getNodes()) + ", maxRedirects=" + this.getMaxRedirects() + ")";
        }
    }
}

