/*
 * Decompiled with CFR 0.152.
 */
package com.livk.autoconfigure.redisearch;

import com.livk.autoconfigure.redisearch.RediSearchProperties;
import com.redis.lettucemod.RedisModulesClient;
import com.redis.lettucemod.api.StatefulRedisModulesConnection;
import com.redis.lettucemod.cluster.RedisModulesClusterClient;
import io.lettuce.core.RedisCredentials;
import io.lettuce.core.RedisCredentialsProvider;
import io.lettuce.core.RedisURI;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.support.ConnectionPoolSupport;
import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

final class RediSearchSupport {
    public static List<RedisURI> createCluster(RediSearchProperties properties) {
        return properties.getCluster().getNodes().stream().map(node -> {
            String[] arr = node.split(":");
            RedisURI redisURI = RedisURI.create((String)arr[0], (int)Integer.parseInt(arr[1]));
            RediSearchSupport.config(redisURI, properties);
            return redisURI;
        }).toList();
    }

    public static RedisURI create(RediSearchProperties properties) {
        RedisURI redisURI = RedisURI.create((String)properties.getHost(), (int)properties.getPort());
        RediSearchSupport.config(redisURI, properties);
        return redisURI;
    }

    private static void config(RedisURI redisURI, RediSearchProperties properties) {
        redisURI.setCredentialsProvider(RedisCredentialsProvider.from(() -> RedisCredentials.just((String)properties.getUsername(), (CharSequence)properties.getPassword())));
        redisURI.setDatabase(properties.getDatabase());
        Duration timeout = properties.getTimeout();
        if (timeout != null) {
            redisURI.setTimeout(timeout);
        }
        redisURI.setSsl(properties.getSsl().booleanValue());
        redisURI.setClientName(properties.getClientName());
    }

    public static <T> GenericObjectPoolConfig<T> withPoolConfig(RediSearchProperties properties) {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setJmxEnabled(false);
        RediSearchProperties.Pool pool = properties.getPool();
        if (pool != null) {
            config.setMaxTotal(pool.getMaxActive());
            config.setMaxIdle(pool.getMaxIdle());
            config.setMinIdle(pool.getMinIdle());
            if (pool.getMaxWait() != null) {
                config.setMaxWait(pool.getMaxWait());
            }
        }
        return config;
    }

    public static <K, V> GenericObjectPool<StatefulRedisModulesConnection<K, V>> pool(Supplier<StatefulRedisModulesConnection<K, V>> supplier, GenericObjectPoolConfig<StatefulRedisModulesConnection<K, V>> poolConfig) {
        return ConnectionPoolSupport.createGenericObjectPool(supplier, poolConfig);
    }

    public static <K, V> GenericObjectPool<StatefulRedisModulesConnection<K, V>> pool(RedisModulesClient client, RedisCodec<K, V> redisCodec, GenericObjectPoolConfig<StatefulRedisModulesConnection<K, V>> poolConfig) {
        return RediSearchSupport.pool(() -> client.connect(redisCodec), poolConfig);
    }

    public static <K, V> GenericObjectPool<StatefulRedisModulesConnection<K, V>> pool(RedisModulesClusterClient client, RedisCodec<K, V> redisCodec, GenericObjectPoolConfig<StatefulRedisModulesConnection<K, V>> poolConfig) {
        return RediSearchSupport.pool(() -> client.connect(redisCodec), poolConfig);
    }

    private RediSearchSupport() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

