/*
 * Decompiled with CFR 0.152.
 */
package com.livk.autoconfigure.redisearch.codec;

import com.livk.autoconfigure.redisearch.codec.CodecException;
import com.livk.commons.util.ObjectUtils;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import java.nio.ByteBuffer;

public abstract class AbstractRedisCodec<T>
implements RedisCodec<String, T> {
    private final RedisCodec<String, ?> keyCodec;

    protected AbstractRedisCodec() {
        this((RedisCodec<String, ?>)new StringCodec());
    }

    public final ByteBuffer encodeKey(String key) {
        return this.keyCodec.encodeKey((Object)key);
    }

    public final String decodeKey(ByteBuffer bytes) {
        return (String)this.keyCodec.decodeKey(bytes);
    }

    public final T decodeValue(ByteBuffer bytes) {
        ByteBuffer allocate = ByteBuffer.allocate(bytes.capacity());
        byte[] array = allocate.put(bytes).array();
        if (ObjectUtils.isEmpty((Object)array)) {
            return null;
        }
        return this.deserialize(array);
    }

    public final ByteBuffer encodeValue(T value) {
        if (value == null) {
            return ByteBuffer.wrap(new byte[0]);
        }
        byte[] bytes = this.serialize(value);
        return ByteBuffer.wrap(bytes);
    }

    protected abstract byte[] serialize(T var1) throws CodecException;

    protected abstract T deserialize(byte[] var1) throws CodecException;

    protected AbstractRedisCodec(RedisCodec<String, ?> keyCodec) {
        this.keyCodec = keyCodec;
    }
}

