/*
 * Decompiled with CFR 0.152.
 */
package com.livk.autoconfigure.redisearch.codec;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.livk.autoconfigure.redisearch.codec.AbstractRedisCodec;
import com.livk.autoconfigure.redisearch.codec.CodecException;
import org.springframework.util.Assert;

public class JacksonRedisCodec<T>
extends AbstractRedisCodec<T> {
    private final ObjectMapper mapper;
    private final JavaType javaType;

    public JacksonRedisCodec(Class<T> type) {
        this(new ObjectMapper(), type);
    }

    public JacksonRedisCodec(JavaType javaType) {
        this(new ObjectMapper(), javaType);
    }

    public JacksonRedisCodec(ObjectMapper mapper, Class<T> type) {
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null");
        Assert.notNull(type, (String)"Java type must not be null");
        this.javaType = this.getJavaType(type);
        this.mapper = mapper;
    }

    private JavaType getJavaType(Class<?> clazz) {
        return TypeFactory.defaultInstance().constructType(clazz);
    }

    @Override
    protected byte[] serialize(T value) throws CodecException {
        try {
            return this.mapper.writeValueAsBytes(value);
        }
        catch (Exception ex) {
            throw new CodecException("Could not write JSON: " + ex.getMessage(), ex);
        }
    }

    @Override
    protected T deserialize(byte[] bytes) throws CodecException {
        try {
            return (T)this.mapper.readValue(bytes, this.javaType);
        }
        catch (Exception ex) {
            throw new CodecException("Could not read JSON: " + ex.getMessage(), ex);
        }
    }

    public JacksonRedisCodec(ObjectMapper mapper, JavaType javaType) {
        this.mapper = mapper;
        this.javaType = javaType;
    }
}

